/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.cache304;

import icu.easyj.core.exception.SkipCallbackWrapperException;
import icu.easyj.web.cache304.Cache304Aspect;
import icu.easyj.web.cache304.Cache304Utils;
import icu.easyj.web.cache304.config.Cache304Config;
import icu.easyj.web.cache304.config.Cache304ConfigManagerFactory;
import icu.easyj.web.filter.FilterAdapter;
import icu.easyj.web.util.HttpUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;

@Order(value=-2147483638)
public class Cache304Filter
implements FilterAdapter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (HttpUtils.isNotGetRequest(httpRequest)) {
            chain.doFilter(request, response);
            return;
        }
        Cache304Config config = Cache304ConfigManagerFactory.getInstance().getConfig(httpRequest);
        if (config != null) {
            Cache304Aspect.disable();
        }
        try {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            Cache304Utils.doCache(httpRequest, httpResponse, config, () -> {
                try {
                    chain.doFilter(request, response);
                }
                catch (IOException | ServletException e) {
                    throw new SkipCallbackWrapperException(e);
                }
            });
        }
        catch (SkipCallbackWrapperException ex) {
            Throwable e = ex.getCause();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (ServletException)e;
        }
        finally {
            if (config != null) {
                Cache304Aspect.enable();
            }
        }
    }
}

