/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.login;

import icu.easyj.core.util.ArrayUtils;
import icu.easyj.login.AllowLoginStatus;
import icu.easyj.login.ILoginValidatorExceptionHandler;
import icu.easyj.login.LoginUtils;
import icu.easyj.login.LoginValidator;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-2147483448)
public class LoginValidatorAspect {
    private final ILoginValidatorExceptionHandler loginValidatorExceptionHandler;

    public LoginValidatorAspect(ILoginValidatorExceptionHandler loginValidatorExceptionHandler) {
        this.loginValidatorExceptionHandler = loginValidatorExceptionHandler;
    }

    @Pointcut(value="@within(icu.easyj.login.LoginValidator) || @annotation(icu.easyj.login.LoginValidator)")
    public static void pointCutLoginValidate() {
    }

    @Before(value="pointCutLoginValidate()")
    public void loginValidate(JoinPoint jp) throws Exception {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        LoginValidator anno = method.getAnnotation(LoginValidator.class);
        if (anno == null && (anno = method.getDeclaringClass().getAnnotation(LoginValidator.class)) == null) {
            return;
        }
        if (!anno.exist()) {
            return;
        }
        boolean isLogined = LoginUtils.isLogined();
        if (isLogined) {
            if (anno.allowState() == AllowLoginStatus.UN_LOGIN_ONLY) {
                this.loginValidatorExceptionHandler.handle("ONLY_ALLOW_UN_LOGIN", "\u8be5\u63a5\u53e3\u672a\u767b\u5f55\u72b6\u6001\u4e0b\u624d\u53ef\u8c03\u7528");
            }
        } else if (anno.allowState() == AllowLoginStatus.LOGIN_ONLY) {
            this.loginValidatorExceptionHandler.handle("NOT_LOGIN", "\u60a8\u8fd8\u672a\u767b\u5f55\u6216\u767b\u5f55\u5df2\u8fc7\u671f");
        }
        if (isLogined) {
            String[] roles = anno.value();
            if (ArrayUtils.isEmpty(roles)) {
                return;
            }
            String mainRole = LoginUtils.getMainRole();
            for (String role : roles) {
                if (!role.equals(mainRole)) continue;
                return;
            }
            this.loginValidatorExceptionHandler.handle("NOT_ALLOW_ROLE", "\u4e0d\u5141\u8bb8\u5f53\u524d\u7528\u6237\u8bbf\u95ee\u8be5\u63a5\u53e3");
        }
    }
}

