/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.jwt.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.util.MapUtils;
import icu.easyj.jwt.IJwt;
import icu.easyj.jwt.JwtInfo;
import icu.easyj.jwt.JwtUtils;
import icu.easyj.jwt.SecretKeyUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import org.springframework.util.Assert;

@LoadLevel(name="jjwt", order=0)
public class JJwt
implements IJwt {
    private final SignatureAlgorithm signatureAlgorithm;
    private final Key secretKey;

    public JJwt(SignatureAlgorithm signatureAlgorithm, Key secretKey) {
        Assert.notNull((Object)signatureAlgorithm, (String)"'signatureAlgorithm' must be not null");
        Assert.notNull((Object)secretKey, (String)"'secretKey' must be not null");
        this.signatureAlgorithm = signatureAlgorithm;
        this.secretKey = secretKey;
    }

    public JJwt(SignatureAlgorithm signatureAlgorithm, String secretKeyStr, String secretKeyAlgorithm) {
        Assert.notNull((Object)signatureAlgorithm, (String)"'signatureAlgorithm' must be not null");
        Assert.notNull((Object)secretKeyStr, (String)"'secretKeyStr' must be not null");
        Assert.notNull((Object)secretKeyAlgorithm, (String)"'secretKeyAlgorithm' must be not null");
        this.signatureAlgorithm = signatureAlgorithm;
        this.secretKey = SecretKeyUtils.generate(secretKeyStr, secretKeyAlgorithm);
    }

    public JJwt(String signatureAlgorithmStr, String secretKeyStr, String secretKeyAlgorithm) {
        Assert.notNull((Object)signatureAlgorithmStr, (String)"'signatureAlgorithmStr' must be not null");
        Assert.notNull((Object)secretKeyStr, (String)"'secretKeyStr' must be not null");
        Assert.notNull((Object)secretKeyAlgorithm, (String)"'secretKeyAlgorithm' must be not null");
        this.signatureAlgorithm = SignatureAlgorithm.valueOf((String)signatureAlgorithmStr);
        this.secretKey = SecretKeyUtils.generate(secretKeyStr, secretKeyAlgorithm);
    }

    @Override
    public String create(String jwtId, Map<String, Object> claims, Date issuedAt, Date expiresAt) {
        JwtBuilder builder = Jwts.builder();
        if (jwtId != null) {
            builder.setId(jwtId);
        }
        if (MapUtils.isNotEmpty(claims)) {
            builder.addClaims(claims);
        }
        if (issuedAt == null) {
            issuedAt = new Date();
        }
        builder.setIssuedAt(issuedAt);
        if (expiresAt != null) {
            builder.setExpiration(expiresAt);
        }
        builder.signWith(this.signatureAlgorithm, this.secretKey);
        return builder.compact();
    }

    @Override
    public JwtInfo parse(String jwtStr, long leeway) {
        Assert.notNull((Object)jwtStr, (String)"'jwtStr' must be not null");
        Claims claims = (Claims)Jwts.parser().setAllowedClockSkewSeconds(leeway >= 0L ? leeway : 0L).setSigningKey(this.secretKey).parseClaimsJws(jwtStr).getBody();
        String jwtId = claims.getId();
        Date issuedAt = claims.getIssuedAt();
        Date expiresAt = claims.getExpiration();
        JwtUtils.removeSpecialClaims((Map<String, Object>)claims);
        return new JwtInfo(jwtId, (Map<String, Object>)claims, issuedAt, expiresAt);
    }
}

