/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.login;

import icu.easyj.core.util.StringUtils;
import icu.easyj.jwt.IJwt;
import icu.easyj.jwt.JwtInfo;
import icu.easyj.login.ILoginProperties;
import icu.easyj.login.ILoginTokenBuilder;
import icu.easyj.login.LoginInfo;
import icu.easyj.login.LoginTokenInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JwtLoginTokenBuilder
implements ILoginTokenBuilder {
    private final IJwt jwt;
    private final ILoginProperties properties;

    public JwtLoginTokenBuilder(IJwt jwt, ILoginProperties properties) {
        Assert.notNull((Object)jwt, (String)"'jwt' must be not null");
        Assert.notNull((Object)properties, (String)"'properties' must be not null");
        this.jwt = jwt;
        this.properties = properties;
    }

    @Override
    @NonNull
    public LoginTokenInfo create(String loginId, Map<String, Object> loginData, Date loginTime) {
        String token = this.jwt.create(loginId, loginData, loginTime, this.properties.getTokenExpiredTime());
        String refreshToken = this.jwt.create(loginId, null, new Date(), this.properties.getRefreshTokenExpiredTime());
        return new LoginTokenInfo(token, refreshToken);
    }

    @Override
    @NonNull
    public LoginInfo<?, ?> parse(String token) {
        JwtInfo jwtInfo = this.jwt.parse(token);
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setToken(token);
        loginInfo.setLoginId(jwtInfo.getJwtId());
        loginInfo.setAccountId(jwtInfo.getClaims("accountId", Serializable.class));
        loginInfo.setUserId(jwtInfo.getClaims("userId", Serializable.class));
        loginInfo.setUserName(jwtInfo.getClaims("userName", String.class));
        loginInfo.setLoginClient(jwtInfo.getClaims("loginClient", String.class));
        loginInfo.setMainRole(jwtInfo.getClaims("mainRole", String.class));
        loginInfo.setRoles(this.getRoles(jwtInfo.getClaims("roles", String.class)));
        loginInfo.setLoginTime(jwtInfo.getClaims("loginTime", Date.class));
        if (loginInfo.getLoginTime() == null) {
            loginInfo.setLoginTime(jwtInfo.getIssuedAt());
        }
        loginInfo.setLoginExpiredTime(jwtInfo.getExpiresAt());
        loginInfo.setData(jwtInfo.getClaims());
        return loginInfo;
    }

    @Override
    @NonNull
    public LoginTokenInfo refresh(String token, String refreshToken) {
        JwtInfo jwtInfo = this.jwt.parse(token);
        JwtInfo refreshJwtInfo = this.jwt.parse(refreshToken);
        if (!jwtInfo.getJwtId().equals(refreshJwtInfo.getJwtId())) {
            throw new IllegalArgumentException("\u5f53\u524drefreshToken\u4e0etoken\u4e0d\u5339\u914d");
        }
        int passSeconds = (int)(System.currentTimeMillis() - jwtInfo.getIssuedAt().getTime()) / 1000;
        String newToken = this.jwt.create(jwtInfo.getJwtId(), jwtInfo.getClaims(), jwtInfo.getIssuedAt(), passSeconds + this.properties.getTokenExpiredTime());
        String newRefreshToken = this.jwt.create(jwtInfo.getJwtId(), null, refreshJwtInfo.getIssuedAt(), passSeconds + this.properties.getRefreshTokenExpiredTime());
        return new LoginTokenInfo(newToken, newRefreshToken);
    }

    @Nullable
    private List<String> getRoles(String rolesStr) {
        if (StringUtils.isEmpty(rolesStr)) {
            return null;
        }
        String[] roles = rolesStr.split(",");
        return Arrays.asList(roles);
    }
}

