/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.login;

import icu.easyj.core.context.ContextUtils;
import icu.easyj.core.convert.ConvertUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.login.LoginInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class LoginUtils {
    private static final String CONTEXT_KEY = "loginInfo";

    @Nullable
    public static LoginInfo<?, ?> getLoginInfo() {
        return (LoginInfo)ContextUtils.get(CONTEXT_KEY);
    }

    public static void setLoginInfo(LoginInfo<?, ?> loginInfo) {
        Assert.notNull(loginInfo, (String)"'loginInfo' must be not null");
        Assert.notNull((Object)loginInfo.getLoginId(), (String)"'loginId' must be not null");
        Assert.notNull(loginInfo.getUserId(), (String)"'userId' must be not null");
        Assert.notNull((Object)loginInfo.getLoginTime(), (String)"'loginTime' must be not null");
        ContextUtils.put(CONTEXT_KEY, loginInfo);
    }

    public static void clear() {
        ContextUtils.remove(CONTEXT_KEY);
    }

    public static boolean isLogined() {
        return LoginUtils.getLoginInfo() != null;
    }

    private static <R> R get(Function<LoginInfo<?, ?>, R> function) {
        LoginInfo<?, ?> loginInfo = LoginUtils.getLoginInfo();
        if (loginInfo != null) {
            return function.apply(loginInfo);
        }
        return null;
    }

    public static String getToken() {
        return LoginUtils.get(LoginInfo::getToken);
    }

    public static String getLoginId() {
        return LoginUtils.get(LoginInfo::getLoginId);
    }

    public static <AID extends Serializable> AID getAccountId() {
        return (AID)LoginUtils.get(LoginInfo::getAccountId);
    }

    public static <UID extends Serializable> UID getUserId() {
        return (UID)LoginUtils.get(LoginInfo::getUserId);
    }

    public static String getUserName() {
        return LoginUtils.get(LoginInfo::getUserName);
    }

    public static String getMainRole() {
        return LoginUtils.get(LoginInfo::getMainRole);
    }

    public static List<String> getRoles() {
        return LoginUtils.get(LoginInfo::getRoles);
    }

    public static Date getLoginTime() {
        return LoginUtils.get(LoginInfo::getLoginTime);
    }

    public static Date getLoginExpiredTime() {
        return LoginUtils.get(LoginInfo::getLoginExpiredTime);
    }

    public static Map<String, Object> getData() {
        return LoginUtils.get(LoginInfo::getData);
    }

    @Nullable
    public static <D> D getData(String key) {
        Map map = LoginUtils.get(LoginInfo::getData);
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        return (D)map.get(key);
    }

    @Nullable
    public static <D> D getData(String key, Class<D> clazz) {
        Map map = LoginUtils.get(LoginInfo::getData);
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        Object data = map.get(key);
        if (data == null) {
            return null;
        }
        return ConvertUtils.convert(data, clazz);
    }
}

