/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.param.crypto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONPObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonContainer;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.alibaba.fastjson.support.spring.MappingFastJsonValue;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import icu.easyj.core.util.StringUtils;
import icu.easyj.web.param.crypto.ParamCryptoFilter;
import icu.easyj.web.param.crypto.exception.ParamDecryptException;
import icu.easyj.web.param.crypto.exception.ParamEncryptException;
import icu.easyj.web.util.BodyHolder;
import icu.easyj.web.util.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class FastJsonParamCryptoHttpMessageConverter
extends FastJsonHttpMessageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FastJsonParamCryptoHttpMessageConverter.class);
    public static final SerializeFilter[] EMPTY_FILTER_ARRAY = new SerializeFilter[0];
    private final ParamCryptoFilter paramCryptoFilter;

    public FastJsonParamCryptoHttpMessageConverter(@NonNull ParamCryptoFilter paramCryptoFilter) {
        Assert.notNull((Object)paramCryptoFilter, (String)"'paramCryptoFilter' must not be null");
        this.paramCryptoFilter = paramCryptoFilter;
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        return this.readType(this.getType(type, contextClass), inputMessage);
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        return this.readType(this.getType(clazz, null), inputMessage);
    }

    protected Object readType(Type type, HttpInputMessage inputMessage) {
        FastJsonConfig fastJsonConfig = super.getFastJsonConfig();
        try {
            String bodyJsonStr;
            String body = BodyHolder.getBody();
            if (body == null) {
                body = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)fastJsonConfig.getCharset());
            } else {
                BodyHolder.removeBody();
            }
            if (this.isNeedDecryptBody(body)) {
                try {
                    bodyJsonStr = this.paramCryptoFilter.getCryptoHandler().decrypt(body);
                }
                catch (RuntimeException e) {
                    LOGGER.error("Body\u5165\u53c2\u672a\u52a0\u5bc6\u6216\u683c\u5f0f\u6709\u8bef\uff0c\u89e3\u5bc6\u5931\u8d25\uff01\r\n==>\r\nBody: {}\r\nErrorMessage: {}\r\n<==", (Object)body, (Object)e.getMessage());
                    if (e instanceof ParamDecryptException) {
                        throw e;
                    }
                    throw new ParamDecryptException("Body\u5165\u53c2\u672a\u52a0\u5bc6\u6216\u683c\u5f0f\u6709\u8bef\uff0c\u89e3\u5bc6\u5931\u8d25", "DECRYPT_FAILED", e);
                }
            } else {
                bodyJsonStr = body;
            }
            body = null;
            Object result = JSON.parseObject((String)bodyJsonStr, (Type)type, (ParserConfig)fastJsonConfig.getParserConfig(), (ParseProcess)fastJsonConfig.getParseProcess(), (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])fastJsonConfig.getFeatures());
            bodyJsonStr = null;
            return result;
        }
        catch (JSONException e) {
            throw new HttpMessageNotReadableException("JSON parse error: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new HttpMessageNotReadableException("I/O error while reading input message", (Throwable)e);
        }
    }

    private boolean isNeedDecryptBody(String body) {
        if (HttpUtils.isInternalRequest()) {
            return false;
        }
        if (!this.paramCryptoFilter.isNeedDoFilter(HttpUtils.getRequest())) {
            return false;
        }
        return this.paramCryptoFilter.getCryptoHandlerProperties().isNeedEncryptInputParam() || this.paramCryptoFilter.getCryptoHandler().isEncryptedQueryString(body);
    }

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        FastJsonConfig fastJsonConfig = super.getFastJsonConfig();
        try (ByteArrayOutputStream outnew = new ByteArrayOutputStream();){
            int len;
            HttpHeaders headers = outputMessage.getHeaders();
            SerializeFilter[] globalFilters = fastJsonConfig.getSerializeFilters();
            ArrayList<SerializeFilter> allFilters = new ArrayList<SerializeFilter>(Arrays.asList(globalFilters));
            boolean isJsonp = false;
            Object value = this.strangeCodeForJackson(object);
            if (value instanceof FastJsonContainer) {
                FastJsonContainer fastJsonContainer = (FastJsonContainer)value;
                PropertyPreFilters filters = fastJsonContainer.getFilters();
                allFilters.addAll(filters.getFilters());
                value = fastJsonContainer.getValue();
            }
            if (value instanceof MappingFastJsonValue) {
                if (!StringUtils.isEmpty(((MappingFastJsonValue)value).getJsonpFunction())) {
                    isJsonp = true;
                }
            } else if (value instanceof JSONPObject) {
                isJsonp = true;
            }
            boolean isEncrypt = false;
            if (!HttpUtils.isInternalRequest() && this.paramCryptoFilter.isNeedDoFilter(HttpUtils.getRequest()) && this.paramCryptoFilter.getCryptoHandlerProperties().isNeedEncryptOutputParam()) {
                String jsonStr = JSON.toJSONString((Object)value, (SerializeConfig)fastJsonConfig.getSerializeConfig(), (SerializeFilter[])allFilters.toArray(EMPTY_FILTER_ARRAY), (String)fastJsonConfig.getDateFormat(), (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])fastJsonConfig.getSerializerFeatures());
                try {
                    value = this.paramCryptoFilter.getCryptoHandler().encrypt(jsonStr);
                }
                catch (ParamEncryptException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new ParamEncryptException("\u51fa\u53c2\u52a0\u5bc6\u5931\u8d25", "ENCRYPT_FAILED", e);
                }
                isEncrypt = true;
            }
            int n = len = !isJsonp && isEncrypt ? value.toString().length() : JSON.writeJSONStringWithFastJsonConfig((OutputStream)outnew, (Charset)fastJsonConfig.getCharset(), (Object)value, (SerializeConfig)fastJsonConfig.getSerializeConfig(), (SerializeFilter[])allFilters.toArray(EMPTY_FILTER_ARRAY), (String)fastJsonConfig.getDateFormat(), (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])fastJsonConfig.getSerializerFeatures());
            if (isJsonp) {
                headers.setContentType(APPLICATION_JAVASCRIPT);
            } else if (isEncrypt) {
                headers.setContentType(MediaType.TEXT_PLAIN);
                outnew.write(value.toString().getBytes(fastJsonConfig.getCharset()));
            } else {
                headers.setContentType(MediaType.APPLICATION_JSON);
            }
            if (fastJsonConfig.isWriteContentLength()) {
                headers.setContentLength((long)len);
            }
            outnew.writeTo(outputMessage.getBody());
        }
        catch (JSONException jsonException) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + jsonException.getMessage(), (Throwable)jsonException);
        }
    }

    protected Object strangeCodeForJackson(Object obj) {
        String className;
        if (obj != null && "com.fasterxml.jackson.databind.node.ObjectNode".equals(className = obj.getClass().getName())) {
            return obj.toString();
        }
        return obj;
    }
}

