/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.code.analysis;

import icu.easyj.core.code.analysis.CodeAnalysisResult;
import icu.easyj.core.exception.AnalysisException;
import icu.easyj.core.util.PatternUtils;
import icu.easyj.core.util.StringUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.lang.NonNull;

public abstract class CodeAnalysisUtils {
    @NonNull
    public static Object[] analysisParameters(String parametersStr, int limitParameterSize) {
        if (StringUtils.isBlank(parametersStr) || limitParameterSize <= 0) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        Matcher mParameter = PatternUtils.P_CODE_DATA_VALUE.matcher(parametersStr);
        ArrayList<Object> parameterList = new ArrayList<Object>();
        block12: while (parameterList.size() < limitParameterSize && mParameter.find()) {
            String specialStr;
            String parameter;
            switch (parameter = mParameter.group()) {
                case "null": {
                    parameterList.add(null);
                    continue block12;
                }
                case "true": {
                    parameterList.add(true);
                    continue block12;
                }
                case "false": {
                    parameterList.add(false);
                    continue block12;
                }
            }
            char firstChar = parameter.charAt(0);
            if (firstChar != '\'' && firstChar != '\"') {
                char lastChar = parameter.charAt(parameter.length() - 1);
                if (parameter.contains(".")) {
                    if (lastChar == 'F' || lastChar == 'f') {
                        parameterList.add(Float.valueOf(parameter));
                        continue;
                    }
                    parameterList.add(Double.valueOf(parameter));
                    continue;
                }
                if (lastChar == 'L' || lastChar == 'l') {
                    parameterList.add(Long.valueOf(parameter.substring(0, parameter.length() - 1)));
                    continue;
                }
                try {
                    parameterList.add(Integer.valueOf(parameter));
                }
                catch (NumberFormatException e) {
                    parameterList.add(Long.valueOf(parameter));
                }
                continue;
            }
            String c = String.valueOf(firstChar);
            if ((parameter = parameter.substring(1, parameter.length() - 1)).contains(specialStr = "\\" + c)) {
                parameter = parameter.replace(specialStr, c);
            }
            parameterList.add(parameter);
        }
        if (parameterList.isEmpty()) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        return parameterList.toArray(ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    @NonNull
    public static Object[] analysisParameters(String parametersStr) {
        return CodeAnalysisUtils.analysisParameters(parametersStr, Integer.MAX_VALUE);
    }

    @NonNull
    public static CodeAnalysisResult analysisCode(String code, int limitParameterSize, boolean isRigorous) {
        String fieldOrMethodName;
        if (code == null) {
            throw new IllegalArgumentException("'code' must not be null");
        }
        Matcher m = (isRigorous ? PatternUtils.P_CODE_LINE : PatternUtils.P_CODE_LINE2).matcher(code.trim());
        if (!m.matches()) {
            throw new AnalysisException("\u89e3\u6790\u4ee3\u7801\u5931\u8d25\uff1a\u65e0\u6548\u7684\u4ee3\u7801\u884c", "INVALID_CODE");
        }
        CodeAnalysisResult result = new CodeAnalysisResult();
        String variableName = m.groupCount() > 0 ? m.group(1) : null;
        result.setVariableName(variableName);
        String string = fieldOrMethodName = m.groupCount() >= 4 ? m.group(3) : null;
        if (code.contains("(")) {
            result.setMethodName(fieldOrMethodName);
            String parametersStr = m.groupCount() >= 6 ? m.group(5) : null;
            Object[] parameters = CodeAnalysisUtils.analysisParameters(parametersStr, limitParameterSize);
            result.setParameters(parameters);
        } else {
            result.setFieldName(fieldOrMethodName);
        }
        return result;
    }

    @NonNull
    public static CodeAnalysisResult analysisCode(String code, boolean isRigorous) {
        return CodeAnalysisUtils.analysisCode(code, Integer.MAX_VALUE, isRigorous);
    }

    @NonNull
    public static CodeAnalysisResult analysisCode(String code, int limitParameterSize) {
        return CodeAnalysisUtils.analysisCode(code, limitParameterSize, false);
    }

    @NonNull
    public static CodeAnalysisResult analysisCode(String code) {
        return CodeAnalysisUtils.analysisCode(code, Integer.MAX_VALUE, false);
    }
}

