/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.codec;

import icu.easyj.core.codec.IBase64Service;
import icu.easyj.core.loader.EnhancedServiceLoader;
import java.nio.charset.StandardCharsets;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class Base64Utils {
    private static final IBase64Service BASE64_SERVICE = EnhancedServiceLoader.load(IBase64Service.class);
    public static final byte[] BASE64_CHAR_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    public static final byte MIN_BASE64_BYTE = 43;
    public static final byte MAX_BASE64_BYTE = 122;
    public static final byte PADDING_CHAR = 61;

    @NonNull
    public static String normalize(@NonNull String base64Str) throws IllegalArgumentException {
        Assert.notNull((Object)base64Str, (String)"'base64Str' must not be null");
        boolean needToChange = false;
        int base64Length = base64Str.length();
        StringBuilder sb = new StringBuilder(base64Length > 500 ? base64Length / 2 : base64Length);
        int i = 0;
        byte[] bytes = null;
        block8: while (i < base64Length) {
            char c = base64Str.charAt(i);
            switch (c) {
                case ' ': 
                case '-': {
                    sb.append('+');
                    ++i;
                    needToChange = true;
                    continue block8;
                }
                case '_': {
                    sb.append('/');
                    ++i;
                    needToChange = true;
                    continue block8;
                }
                case '\n': 
                case '\r': 
                case '\"': {
                    ++i;
                    needToChange = true;
                    continue block8;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(base64Length - i) / 3];
                        }
                        int pos = 0;
                        while (c == '%' && i + 2 < base64Length) {
                            String hex = base64Str.substring(i + 1, i + 3);
                            int v = Integer.parseInt(hex, 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("\u8f6c\u4e49\uff08%\uff09\u6a21\u5f0f\u65f6\u5b58\u5728\u975e\u6cd5\u5341\u516d\u8fdb\u5236\u5b57\u7b26-\u8d1f\u503c: %" + hex + " -> " + v);
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= base64Length) continue;
                            c = base64Str.charAt(i);
                        }
                        if (c == '%' && i < base64Length) {
                            throw new IllegalArgumentException("\u4e0d\u5b8c\u6574\u7684\u8f6c\u4e49\uff08%\uff09\u6a21\u5f0f");
                        }
                        sb.append(new String(bytes, 0, pos, StandardCharsets.UTF_8));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("\u8f6c\u4e49\uff08%\uff09\u6a21\u5f0f\u4e2d\u7684\u975e\u6cd5\u5341\u516d\u8fdb\u5236\u5b57\u7b26 - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block8;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : base64Str;
    }

    private static boolean isBase64CharInner(char c) {
        return c >= '+' && c <= 'z' && BASE64_CHAR_TABLE[c] != -1;
    }

    private static boolean isBase64ByteInner(byte b) {
        return b >= 43 && b <= 122 && BASE64_CHAR_TABLE[b] != -1;
    }

    public static boolean isBase64Char(char c) {
        return c == '=' || Base64Utils.isBase64CharInner(c);
    }

    public static boolean isBase64Byte(byte b) {
        return b == 61 || Base64Utils.isBase64ByteInner(b);
    }

    public static boolean isBase64(@Nullable CharSequence cs) {
        if (cs == null) {
            return false;
        }
        return BASE64_SERVICE.isBase64(cs);
    }

    public static boolean isBase64Chars(@Nullable char[] chars) {
        int length;
        if (chars == null || (length = chars.length) < 2) {
            return false;
        }
        char c = chars[length - 1];
        if (c == '=') {
            if (length % 4 != 0) {
                return false;
            }
            if ((c = chars[--length - 1]) != '=' && !Base64Utils.isBase64CharInner(c)) {
                return false;
            }
        } else {
            if (length % 4 == 1) {
                return false;
            }
            if (!Base64Utils.isBase64CharInner(c)) {
                return false;
            }
        }
        --length;
        for (int i = 0; i < length; ++i) {
            if (Base64Utils.isBase64CharInner(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isBase64Bytes(@Nullable byte[] bytes) {
        int length;
        if (bytes == null || (length = bytes.length) < 2) {
            return false;
        }
        byte b = bytes[length - 1];
        if (b == 61) {
            if (length % 4 != 0) {
                return false;
            }
            if ((b = bytes[--length - 1]) != 61 && !Base64Utils.isBase64ByteInner(b)) {
                return false;
            }
        } else {
            if (length % 4 == 1) {
                return false;
            }
            if (!Base64Utils.isBase64ByteInner(b)) {
                return false;
            }
        }
        --length;
        for (int i = 0; i < length; ++i) {
            if (Base64Utils.isBase64ByteInner(bytes[i])) continue;
            return false;
        }
        return true;
    }
}

