/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.CycleDependencyHandler;
import icu.easyj.core.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class MapUtils {
    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtils.isEmpty(map);
    }

    public static <T extends Map<?, ?>> T defaultIfEmpty(T map, T defaultValue) {
        if (MapUtils.isEmpty(map)) {
            return defaultValue;
        }
        return map;
    }

    public static <T extends Map<?, ?>> T defaultIfEmpty(T map, Supplier<T> defaultValueSupplier) {
        if (MapUtils.isEmpty(map)) {
            return (T)((Map)defaultValueSupplier.get());
        }
        return map;
    }

    public static <K, V> Map<K, V> quickMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> quickMap(K key1, V value1, K key2, V value2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> quickMap(K key1, V value1, K key2, V value2, K key3, V value3) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        return map.computeIfAbsent((K)key, mappingFunction);
    }

    public static String toString(Map<?, ?> map) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "{}";
        }
        return CycleDependencyHandler.wrap(map, o -> {
            StringBuilder sb = new StringBuilder(32);
            sb.append("{");
            map.forEach((key, value) -> {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                if (key == map) {
                    sb.append("(this ").append(map.getClass().getSimpleName()).append(")");
                } else {
                    sb.append(StringUtils.toString(key));
                }
                sb.append(" -> ");
                if (value == map) {
                    sb.append("(this ").append(map.getClass().getSimpleName()).append(")");
                } else {
                    sb.append(StringUtils.toString(value));
                }
            });
            sb.append("}");
            return sb.toString();
        });
    }
}

