/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.loader.condition;

import icu.easyj.core.loader.condition.DependsOnClass;
import icu.easyj.core.loader.condition.IDependsOnValidator;
import icu.easyj.core.loader.condition.ServiceDependencyException;
import icu.easyj.core.loader.condition.ValidateStrategy;
import icu.easyj.core.util.ArrayUtils;

public class DependsOnClassValidator
implements IDependsOnValidator {
    @Override
    public void validate(Class<?> serviceClass, ClassLoader classLoader) throws ServiceDependencyException {
        DependsOnClass dependsOnClass;
        block5: {
            try {
                dependsOnClass = serviceClass.getAnnotation(DependsOnClass.class);
            }
            catch (ArrayStoreException | TypeNotPresentException e) {
                throw new ServiceDependencyException("the depends on classes is not found", e);
            }
            if (dependsOnClass == null) {
                return;
            }
            try {
                Class<?>[] e = dependsOnClass.value();
            }
            catch (ArrayStoreException | TypeNotPresentException e) {
                if (dependsOnClass.strategy() != ValidateStrategy.ALL) break block5;
                throw new ServiceDependencyException("the depends on classes is not found", e);
            }
        }
        this.validateClassNames(dependsOnClass, classLoader);
    }

    private void validateClassNames(DependsOnClass dependsOnClass, ClassLoader classLoader) throws ServiceDependencyException {
        String[] dependsOnClassNames = dependsOnClass.name();
        if (ArrayUtils.isEmpty(dependsOnClassNames)) {
            return;
        }
        if (dependsOnClass.strategy() == ValidateStrategy.ALL) {
            try {
                for (String dependsOnClassName : dependsOnClassNames) {
                    Class.forName(dependsOnClassName, true, classLoader);
                }
            }
            catch (ArrayStoreException | ClassNotFoundException | TypeNotPresentException e) {
                throw new ServiceDependencyException("the depends on classes is not found", e);
            }
        } else {
            for (String dependsOnClassName : dependsOnClassNames) {
                try {
                    Class.forName(dependsOnClassName, true, classLoader);
                    return;
                }
                catch (ArrayStoreException | ClassNotFoundException | TypeNotPresentException exception) {
                }
            }
            throw new ServiceDependencyException("all of the depends on classes is not found");
        }
    }
}

