/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import java.util.function.Predicate;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class EnumUtils {
    @NonNull
    public static <E extends Enum<?>> E fromName(Class<E> enumClass, String enumName) {
        Assert.notNull((Object)enumName, (String)"'enumName' must not be null");
        Enum e = EnumUtils.match(enumClass, e1 -> e1.name().equalsIgnoreCase(enumName));
        if (e == null) {
            throw new IllegalArgumentException("unknown enum name '" + enumName + "' for the enum `" + enumClass.getName() + "`.");
        }
        return (E)e;
    }

    @Nullable
    public static <E extends Enum<?>> E match(Class<E> enumClass, Predicate<E> matcher) {
        Enum[] enums;
        Assert.notNull(enumClass, (String)"'enumClass' must not be null");
        Assert.notNull(matcher, (String)"'matcher' must not be null");
        for (Enum e : enums = (Enum[])enumClass.getEnumConstants()) {
            if (!matcher.test(e)) continue;
            return (E)e;
        }
        return null;
    }
}

