/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.dialect.impls;

import icu.easyj.core.exception.NotSupportedException;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import icu.easyj.core.loader.condition.ValidateStrategy;
import icu.easyj.db.dialect.IDbDialect;
import icu.easyj.db.util.SqlUtils;
import org.springframework.lang.NonNull;

@LoadLevel(name="oracle", order=20)
@DependsOnClass(name={"oracle.jdbc.OracleDriver", "oracle.jdbc.driver.OracleDriver"}, strategy=ValidateStrategy.ANY_ONE)
class OracleDbDialect
implements IDbDialect {
    OracleDbDialect() {
    }

    @Override
    public String getVersionSql() {
        return "SELECT version FROM product_component_version WHERE product LIKE 'Oracle%'";
    }

    @Override
    public String getTimeSql() {
        return "SELECT SYSTIMESTAMP FROM DUAL";
    }

    @Override
    public String getSeqCurrValSql(String seqName) {
        return "SELECT " + SqlUtils.removeDangerousCharsForSeqName(seqName).toUpperCase() + ".CURRVAL FROM DUAL";
    }

    @Override
    public String getSeqNextValSql(String seqName) {
        return "SELECT " + SqlUtils.removeDangerousCharsForSeqName(seqName).toUpperCase() + ".NEXTVAL FROM DUAL";
    }

    @Override
    public String getSeqSetValSql(String seqName, long newVal) {
        throw new NotSupportedException("\u6682\u4e0d\u652f\u6301Oracle\u8bbe\u7f6e\u5e8f\u5217\u503c");
    }

    @Override
    @NonNull
    public String getDbType() {
        return "oracle";
    }
}

