/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.clock;

import cn.hutool.core.thread.NamedThreadFactory;
import icu.easyj.core.clock.HighAccuracyRefreshableTickClock;
import icu.easyj.core.clock.IAutoRefreshTickClock;
import icu.easyj.core.clock.ITickClock;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.security.auth.DestroyFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class AutoRefreshHighAccuracyTickClock
extends HighAccuracyRefreshableTickClock
implements IAutoRefreshTickClock {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoRefreshHighAccuracyTickClock.class);
    private final String name;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private ScheduledFuture<?> scheduledFuture;

    public AutoRefreshHighAccuracyTickClock(String name, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, @NonNull Supplier<ITickClock> tickClockSupplier, int tryCount) {
        super(tickClockSupplier, tryCount);
        Assert.notNull((Object)name, (String)"'name' must be not null");
        this.name = name;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.startAutoRefresh();
    }

    public AutoRefreshHighAccuracyTickClock(String name, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, @NonNull Supplier<ITickClock> tickClockSupplier) {
        this(name, scheduledThreadPoolExecutor, tickClockSupplier, 10);
    }

    public AutoRefreshHighAccuracyTickClock(String name, @NonNull Supplier<ITickClock> tickClockSupplier, int tryCount) {
        this(name, new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory(name + "-AutoRefreshTask-", true)), tickClockSupplier, tryCount);
    }

    public AutoRefreshHighAccuracyTickClock(String name, @NonNull Supplier<ITickClock> tickClockSupplier) {
        this(name, tickClockSupplier, 10);
    }

    @Override
    public synchronized void startAutoRefresh() {
        if (this.isAutoRefreshing()) {
            return;
        }
        long initialDelay = 10L;
        long period = 10L;
        TimeUnit timeUnit = TimeUnit.MINUTES;
        this.scheduledFuture = this.scheduledThreadPoolExecutor.scheduleAtFixedRate(() -> {
            super.refreshTickClock();
            LOGGER.debug("\u8bb0\u53f7\u65f6\u949f '{}' \u5df2\u5b8c\u6210\u65f6\u95f4\u6821\u51c6!", (Object)this.name);
        }, initialDelay, period, timeUnit);
        LOGGER.info("\u5df2\u5f00\u59cb\u8bb0\u53f7\u65f6\u949f '{}' \u7684\u65f6\u95f4\u6821\u51c6\u4efb\u52a1\uff0c\u6267\u884c\u95f4\u9694\uff1a{} \u5206\u949f\u3002", (Object)this.name, (Object)period);
    }

    @Override
    public synchronized void stopAutoRefresh() {
        if (this.isAutoRefreshing()) {
            try {
                this.scheduledFuture.cancel(true);
                LOGGER.info("\u5df2\u505c\u6b62\u8bb0\u53f7\u65f6\u949f '{}' \u7684\u65f6\u95f4\u6821\u51c6\u4efb\u52a1\uff01", (Object)this.name);
            }
            catch (Exception e) {
                LOGGER.error("\u505c\u6b62\u8bb0\u53f7\u65f6\u949f '{}' \u7684\u65f6\u95f4\u6821\u51c6\u4efb\u52a1\u5931\u8d25\uff1a{}", (Object)this.name, (Object)e);
            }
            this.scheduledFuture = null;
        }
    }

    @Override
    public boolean isAutoRefreshing() {
        return this.scheduledFuture != null;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        if (this.isDestroyed()) {
            return;
        }
        this.stopAutoRefresh();
        try {
            this.scheduledThreadPoolExecutor.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("\u81ea\u52a8\u5237\u65b0\u8bb0\u53f7\u65f6\u949f\u7684\u4efb\u52a1 shutdown \u5931\u8d25", (Throwable)e);
        }
        this.scheduledThreadPoolExecutor = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.scheduledThreadPoolExecutor == null;
    }
}

