/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.clock;

import icu.easyj.core.clock.ITickClock;
import icu.easyj.core.clock.RefreshableTickClock;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;

public class HighAccuracyRefreshableTickClock
extends RefreshableTickClock {
    protected static final int MIN_TRY_COUNT = 5;
    protected static final int DEFAULT_TRY_COUNT = 10;
    private final int tryCount;

    public HighAccuracyRefreshableTickClock(@NonNull Supplier<ITickClock> tickClockSupplier, int tryCount) {
        super(tickClockSupplier);
        this.tryCount = Math.max(tryCount, 5);
        this.init();
    }

    public HighAccuracyRefreshableTickClock(@NonNull Supplier<ITickClock> tickClockSupplier) {
        this(tickClockSupplier, 10);
    }

    @Override
    public void refreshTickClock() {
        int tryCount = this.tryCount;
        ITickClock currentTickClock = null;
        do {
            ITickClock newTickClock = this.createClock();
            if (currentTickClock != null && newTickClock.compareTo(currentTickClock) <= 0) continue;
            currentTickClock = newTickClock;
        } while (--tryCount > 0);
        super.setTickClock(currentTickClock);
    }

    public int getTryCount() {
        return this.tryCount;
    }
}

