/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.clock.factory;

import icu.easyj.core.clock.ClockManager;
import icu.easyj.core.clock.IAutoRefreshTickClock;
import icu.easyj.core.clock.IClock;
import icu.easyj.core.clock.factory.IRemotingClockFactory;
import icu.easyj.core.util.MapUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class AbstractRemotingClockFactory<K>
implements IRemotingClockFactory<K> {
    private final ConcurrentMap<K, IAutoRefreshTickClock> remotingClockMap;

    protected AbstractRemotingClockFactory() {
        this(new ConcurrentHashMap(2));
    }

    protected AbstractRemotingClockFactory(ConcurrentMap<K, IAutoRefreshTickClock> remotingClockMap) {
        this.remotingClockMap = remotingClockMap;
    }

    @Override
    @NonNull
    public IAutoRefreshTickClock getClock(@NonNull K remotingKey) {
        Assert.notNull(remotingKey, (String)"'remotingKey' must not be null");
        return MapUtils.computeIfAbsent(this.remotingClockMap, remotingKey, this::createClock);
    }

    @Override
    public void destroyClock(@NonNull K remotingKey) {
        Assert.notNull(remotingKey, (String)"'remotingKey' must not be null");
        ClockManager.destroy((IClock)this.remotingClockMap.remove(remotingKey));
    }
}

