/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.cache304;

import icu.easyj.core.exception.SkipCallbackWrapperException;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.web.cache304.Cache304Utils;
import icu.easyj.web.cache304.annotation.Cache304;
import icu.easyj.web.cache304.annotation.Cache304AnnotationParser;
import icu.easyj.web.cache304.config.Cache304Config;
import icu.easyj.web.cache304.config.Cache304ConfigManagerFactory;
import icu.easyj.web.cache304.config.ICache304ConfigManager;
import icu.easyj.web.util.HttpUtils;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-2147483548)
public class Cache304Aspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cache304Aspect.class);
    private static final ThreadLocal<Boolean> DISABLED_LOCAL = new ThreadLocal();

    public static void disable() {
        DISABLED_LOCAL.set(true);
    }

    public static void enable() {
        DISABLED_LOCAL.remove();
    }

    @Pointcut(value="@annotation(icu.easyj.web.cache304.annotation.Cache304)")
    private void pointcutCache304() {
    }

    @Around(value="pointcutCache304()")
    public Object doCache304(ProceedingJoinPoint jp) throws Throwable {
        if (Boolean.TRUE.equals(DISABLED_LOCAL.get())) {
            return jp.proceed();
        }
        HttpServletRequest request = HttpUtils.getRequest();
        MethodSignature ms = (MethodSignature)jp.getSignature();
        Method method = ms.getMethod();
        if (HttpUtils.isNotGetRequest(request)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("`@{}`\u4e0d\u80fd\u7528\u4e8e\u975eGET\u8bf7\u6c42\uff0c\u5efa\u8bae\u5c06\u8be5\u6ce8\u89e3\u4ece\u65b9\u6cd5`{}`\u4e0a\u79fb\u9664\u6389\u3002", (Object)Cache304.class.getSimpleName(), (Object)ReflectionUtils.methodToString(method));
            }
            return jp.proceed();
        }
        ICache304ConfigManager configManager = Cache304ConfigManagerFactory.getInstance();
        Cache304Config config = configManager.getConfig(request);
        if (config == null) {
            Cache304 anno = method.getAnnotation(Cache304.class);
            config = Cache304AnnotationParser.parse(anno);
            configManager.putConfig(request, config);
        }
        try {
            HttpServletResponse response = HttpUtils.getResponse();
            return Cache304Utils.doCache(request, response, () -> {
                try {
                    return jp.proceed();
                }
                catch (Throwable e) {
                    throw new SkipCallbackWrapperException(e);
                }
            });
        }
        catch (SkipCallbackWrapperException e) {
            throw e.getCause();
        }
    }
}

