/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.converter;

import icu.easyj.core.exception.ConvertException;
import icu.easyj.core.exception.ConverterNotFoundException;
import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.poi.excel.converter.IExcelConverter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.lang.NonNull;

public abstract class ExcelConverterUtils {
    private static final List<IExcelConverter> CONVERTERS = EnhancedServiceLoader.loadAll(IExcelConverter.class);
    private static final Map<Class<?>, IExcelConverter> CLASS_CONVERTER_CACHE = new ConcurrentHashMap();

    @NonNull
    public static IExcelConverter getConverter(@NonNull Class<?> clazz) throws ConverterNotFoundException {
        return MapUtils.computeIfAbsent(CLASS_CONVERTER_CACHE, clazz, k -> {
            if (CollectionUtils.isEmpty(CONVERTERS)) {
                throw new ConverterNotFoundException("\u6ca1\u6709\u4efb\u4f55Excel\u8f6c\u6362\u5668\u53ef\u4ee5\u4f7f\u7528\uff1a" + IExcelConverter.class.getName() + "\uff0c\u5f53\u524d\u6570\u636e\u7c7b\u578b\u4e3a\uff1a" + clazz.getName());
            }
            for (IExcelConverter converter : CONVERTERS) {
                if (!converter.isMatch(clazz)) continue;
                return converter;
            }
            throw new ConverterNotFoundException("\u672a\u5339\u914d\u5230\u5408\u9002\u7684Excel\u8f6c\u6362\u5668\uff0c\u65e0\u6cd5\u8fdb\u884c\u8f6c\u6362\uff0c\u5f53\u524d\u6570\u636e\u7c7b\u578b\u4e3a\uff1a" + clazz.getName());
        });
    }

    public static <T> List<T> toList(InputStream inputStream, Class<T> clazz) throws ConvertException, ConverterNotFoundException {
        IExcelConverter converter = ExcelConverterUtils.getConverter(clazz);
        return ExcelConverterUtils.toList(converter, inputStream, clazz);
    }

    public static <T> List<T> toList(byte[] excelFileBytes, Class<T> clazz) throws ConvertException, ConverterNotFoundException {
        IExcelConverter converter = ExcelConverterUtils.getConverter(clazz);
        return ExcelConverterUtils.toList(converter, new ByteArrayInputStream(excelFileBytes), clazz);
    }

    private static <T> List<T> toList(IExcelConverter converter, InputStream inputStream, Class<T> clazz) {
        try {
            return converter.toList(inputStream, clazz);
        }
        catch (ConvertException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConvertException("excel\u8f6c\u6362\u4e3a\u6570\u636e\u5217\u8868\u5931\u8d25", "EXCEL_TO_LIST_FAILED", e);
        }
    }

    public static <T> Workbook toExcel(List<T> list, Class<T> clazz) throws ConvertException, ConverterNotFoundException {
        IExcelConverter converter = ExcelConverterUtils.getConverter(clazz);
        try {
            return converter.toExcel(list, clazz);
        }
        catch (ConvertException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConvertException("excel\u8f6c\u6362\u4e3a\u6570\u636e\u5217\u8868\u5931\u8d25", "EXCEL_TO_LIST_FAILED", e);
        }
    }
}

