/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.json;

import icu.easyj.core.json.JSONParseException;
import icu.easyj.core.util.TypeBuilder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public interface IJSONService {
    @NonNull
    public String getName();

    @NonNull
    public <T> T toBean(@NonNull String var1, @NonNull Class<T> var2) throws JSONParseException;

    public <T> T toBean(@NonNull String var1, @NonNull Type var2) throws JSONParseException;

    default public <T> T toBean(@NonNull String text, @NonNull Class<T> rawType, Type ... actualTypeArguments) throws JSONParseException {
        ParameterizedType type = TypeBuilder.buildGeneric(rawType, actualTypeArguments);
        return this.toBean(text, type);
    }

    @NonNull
    public <T> List<T> toList(@NonNull String var1, @NonNull Class<T> var2) throws JSONParseException;

    default public <K, V> Map<K, V> toMap(String text, @NonNull Class<K> keyClazz, @NonNull Class<V> valueClazz) {
        return this.toBean(text, Map.class, keyClazz, valueClazz);
    }

    default public <K> Map<K, Object> toMap(String text, @NonNull Class<K> keyClazz) {
        return this.toMap(text, keyClazz, Object.class);
    }

    default public <KV> Map<KV, KV> toMap2(String text, @NonNull Class<KV> keyValueClazz) {
        return this.toMap(text, keyValueClazz, keyValueClazz);
    }

    @NonNull
    public String toJSONString(@Nullable Object var1) throws JSONParseException;
}

