/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.jar;

import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.version.VersionInfo;
import icu.easyj.core.util.version.VersionUtils;
import java.util.Objects;
import java.util.jar.Attributes;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JarInfo {
    public static final String UNKNOWN_GROUP = "<unknown>";
    private final String filePath;
    private final String group;
    private final String name;
    private final VersionInfo versionInfo;
    private final Attributes manifestAttributes;

    public JarInfo(@NonNull String filePath, @NonNull String group, @NonNull String name, @NonNull Attributes manifestAttributes, @Nullable VersionInfo versionInfo) {
        Assert.notNull((Object)filePath, (String)"'filePath' must not be null");
        Assert.isTrue((boolean)StringUtils.isNotBlank(group), (String)"'group' must not be null");
        Assert.isTrue((boolean)StringUtils.isNotBlank(name), (String)"'name' must not be null");
        this.filePath = filePath;
        this.group = group;
        this.name = name.toLowerCase();
        this.versionInfo = versionInfo;
        this.manifestAttributes = manifestAttributes;
    }

    public JarInfo(@NonNull String filePath, @NonNull String group, @NonNull String name, @NonNull Attributes manifestAttributes, @Nullable String version) {
        this(filePath, group, name, manifestAttributes, VersionUtils.parse(version));
    }

    public int compareToVersion(String otherVersion) {
        return this.versionInfo.compareTo(otherVersion);
    }

    public boolean betweenVersion(String startVersion, String toVersion) {
        return this.versionInfo.between(startVersion, toVersion);
    }

    public boolean notBetweenVersion(String startVersion, String toVersion) {
        return this.versionInfo.notBetween(startVersion, toVersion);
    }

    @NonNull
    public String getFilePath() {
        return this.filePath;
    }

    @NonNull
    public String getGroup() {
        return this.group;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.group + ":" + this.name;
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @NonNull
    public String getVersion() {
        return this.versionInfo.getVersion();
    }

    public long getVersionLong() {
        return this.versionInfo.getVersionLong();
    }

    @NonNull
    public Attributes getAttributes() {
        return this.manifestAttributes;
    }

    @Nullable
    public String getAttribute(Attributes.Name name) {
        return this.manifestAttributes.getValue(name);
    }

    @Nullable
    public String getAttribute(String name) {
        return this.manifestAttributes.getValue(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarInfo jarInfo = (JarInfo)o;
        return Objects.equals(this.filePath, jarInfo.filePath) && Objects.equals(this.group, jarInfo.group) && Objects.equals(this.name, jarInfo.name) && Objects.equals(this.versionInfo, jarInfo.versionInfo) && Objects.equals(this.manifestAttributes, jarInfo.manifestAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.filePath, this.group, this.name, this.versionInfo, this.manifestAttributes);
    }
}

