/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.cache304.config;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.util.UrlUtils;
import icu.easyj.web.cache304.config.Cache304Config;
import icu.easyj.web.cache304.config.ICache304ConfigManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

@LoadLevel(name="memory-cache", order=100)
public class DefaultCache304ConfigManagerImpl
implements ICache304ConfigManager {
    private final Map<String, Cache304Config> cache304ConfigMap;

    public DefaultCache304ConfigManagerImpl() {
        this.cache304ConfigMap = new ConcurrentHashMap<String, Cache304Config>(4);
    }

    public DefaultCache304ConfigManagerImpl(Map<String, Cache304Config> cache304ConfigMap) {
        this.cache304ConfigMap = cache304ConfigMap;
    }

    @Override
    public void putConfig(String path, Cache304Config config) {
        Assert.notNull((Object)path, (String)"'path' must not be null");
        Assert.notNull((Object)config, (String)"'config' must not be null");
        path = UrlUtils.normalizePath(path);
        this.cache304ConfigMap.put(path, config);
    }

    @Override
    public Cache304Config getConfig(String path) {
        Assert.notNull((Object)path, (String)"'path' must not be null");
        path = UrlUtils.normalizePath(path);
        return this.cache304ConfigMap.get(path.trim());
    }
}

