/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

public class TimeMeter {
    private final long startNanoTime;

    public TimeMeter(long startNanoTime) {
        this.startNanoTime = startNanoTime;
    }

    public long spendNanoTime() {
        return System.nanoTime() - this.startNanoTime;
    }

    public long spendMicroSeconds() {
        return this.spendNanoTime() / 1000L;
    }

    public long spendMilliSeconds() {
        return this.spendNanoTime() / 1000000L;
    }

    public long spendSeconds() {
        return this.spendNanoTime() / 1000000000L;
    }

    public long getStartNanoTime() {
        return this.startNanoTime;
    }

    public static TimeMeter create(long startNanoTime) {
        return new TimeMeter(startNanoTime);
    }

    public static TimeMeter create() {
        return TimeMeter.create(System.nanoTime());
    }
}

