/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.wrapper;

import icu.easyj.core.util.DateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class HeaderHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final LinkedCaseInsensitiveMap<Object> headers;
    private Enumeration<String> headerNames;

    public HeaderHttpServletRequestWrapper(HttpServletRequest request, LinkedCaseInsensitiveMap<Object> headers) {
        super(request);
        this.headers = headers;
    }

    public Enumeration<String> getHeaderNames() {
        if (this.headerNames == null) {
            Set headerNames = this.headers.keySet();
            Enumeration enumeration = super.getHeaderNames();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    headerNames.add(enumeration.nextElement());
                }
            }
            this.headerNames = Collections.enumeration(headerNames);
        }
        return this.headerNames;
    }

    public Enumeration<String> getHeaders(String name) {
        Object header;
        if (this.headers.containsKey((Object)name) && (header = this.headers.get((Object)name)) != null) {
            String headerStr = String.valueOf(header);
            ArrayList<String> headers = new ArrayList<String>();
            headers.add(headerStr);
            Enumeration enumeration = super.getHeaders(name);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    headers.add((String)enumeration.nextElement());
                }
            }
            return Collections.enumeration(headers);
        }
        return super.getHeaders(name);
    }

    public String getHeader(String name) {
        Object header;
        if (this.headers.containsKey((Object)name) && (header = this.headers.get((Object)name)) != null) {
            return String.valueOf(header);
        }
        return super.getHeader(name);
    }

    public long getDateHeader(String name) {
        Object value;
        if (this.headers.containsKey((Object)name) && (value = this.headers.get((Object)name)) != null) {
            if (value instanceof Date) {
                return ((Date)value).getTime();
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                String str = (String)value;
                try {
                    return Long.parseLong(str);
                }
                catch (NumberFormatException e) {
                    return DateUtils.parseAll(str).getTime();
                }
            }
            return -1L;
        }
        return super.getDateHeader(name);
    }

    public int getIntHeader(String name) {
        Object value;
        if (this.headers.containsKey((Object)name) && (value = this.headers.get((Object)name)) != null) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            return -1;
        }
        return super.getIntHeader(name);
    }
}

