/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.enums.DataType;
import icu.easyj.core.exception.SkipCallbackWrapperException;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.ReflectionUtils;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class DataTypeUtils {
    private static final ConcurrentHashMap<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();

    @NonNull
    public static Class<?> toClass(String dataType) throws ClassNotFoundException {
        Assert.notNull((Object)dataType, (String)"'dataType' must not be null");
        try {
            return MapUtils.computeIfAbsent(CLASS_CACHE, dataType, key -> {
                try {
                    if (dataType.contains(".")) {
                        return ReflectionUtils.getClassByName(dataType);
                    }
                    DataType dataTypeEnum = DataType.getByType(dataType);
                    if (dataTypeEnum == null) {
                        throw new ClassNotFoundException("\u672a\u77e5\u7684\u7c7b\u578b\uff1a" + dataType);
                    }
                    return dataTypeEnum.getClazz();
                }
                catch (ClassNotFoundException e) {
                    throw new SkipCallbackWrapperException(e);
                }
            });
        }
        catch (SkipCallbackWrapperException e) {
            throw (ClassNotFoundException)e.getCause();
        }
    }
}

