/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.shortcode.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.util.shortcode.IShortCodeService;
import icu.easyj.core.util.shortcode.impls.DefaultShortCodeServiceImpl;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

@LoadLevel(name="min-id", order=50)
public class MinIdShortCodeServiceImpl
implements IShortCodeService {
    protected final IShortCodeService shortCodeService;
    protected final long minId;

    public MinIdShortCodeServiceImpl(IShortCodeService shortCodeService, long minId) {
        Assert.notNull((Object)shortCodeService, (String)"'shortCodeService' must not be null");
        Assert.isTrue((minId > 0L ? 1 : 0) != 0, (String)"minId\u5fc5\u987b\u5927\u4e8e0");
        this.shortCodeService = shortCodeService;
        this.minId = minId;
    }

    public MinIdShortCodeServiceImpl(long minId) {
        this(new DefaultShortCodeServiceImpl(), minId);
    }

    @Override
    @NonNull
    public String toCode(@NonNull Long id) {
        Assert.isTrue((id != null && id >= this.minId ? 1 : 0) != 0, (String)("ID\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u5c0fID\uff1a" + this.minId));
        id = id - this.minId;
        return this.shortCodeService.toCode(id);
    }

    @Override
    public long toId(@NonNull String shortCode) {
        long id = this.shortCodeService.toId(shortCode);
        if ((id += this.minId) < this.minId) {
            throw new IllegalArgumentException("\u77ed\u5b57\u7b26\u4e32 '" + shortCode + "' \u6709\u8bef\uff0c\u5b83\u53ef\u80fd\u4e0d\u662f\u5f53\u524d\u670d\u52a1\u751f\u6210\u7684\uff01");
        }
        return id;
    }

    public IShortCodeService getShortCodeService() {
        return this.shortCodeService;
    }

    public long getMinId() {
        return this.minId;
    }
}

