/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import cn.hutool.core.util.URLUtil;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.StringUtils;
import java.io.CharArrayWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class UrlUtils {
    static final BitSet DONT_NEED_URL_ENCODE;

    @NonNull
    public static String normalizePath(String path) {
        Assert.notNull((Object)path, (String)"'path' must not be null");
        path = ((String)path).trim();
        if (((String)path).isEmpty()) {
            return "/";
        }
        if (((String)(path = ((String)path).replace('\\', '/'))).startsWith("http://") || ((String)path).startsWith("https://")) {
            path = URLUtil.getPath((String)path);
        }
        if (((String)(path = ((String)path).replaceAll("[/\\s]+", "/"))).length() > 1 && '/' == ((String)path).charAt(((String)path).length() - 1)) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        if ('/' != ((String)path).charAt(0)) {
            path = "/" + (String)path;
        }
        return path;
    }

    public static String encode(String s, Charset charset) {
        Assert.notNull((Object)s, (String)"'s' must not be null");
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        boolean needToChange = false;
        StringBuilder sb = new StringBuilder(s.length());
        try (CharArrayWriter charArrayWriter = new CharArrayWriter();){
            int i = 0;
            while (i < s.length()) {
                byte[] ba;
                char c;
                int c2 = s.charAt(i);
                if (DONT_NEED_URL_ENCODE.get(c2)) {
                    if (c2 == 32) {
                        c2 = 43;
                        needToChange = true;
                    }
                    sb.append((char)c2);
                    ++i;
                    continue;
                }
                do {
                    char d;
                    charArrayWriter.write(c2);
                    if (c2 >= 55296 && c2 <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                        charArrayWriter.write(d);
                        ++i;
                    }
                    if (++i >= s.length()) break;
                    c = s.charAt(i);
                    c2 = c;
                } while (!DONT_NEED_URL_ENCODE.get(c));
                charArrayWriter.flush();
                String str = charArrayWriter.toString();
                for (byte b : ba = str.getBytes(charset)) {
                    sb.append('%');
                    char ch = Character.forDigit(b >> 4 & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    sb.append(ch);
                    ch = Character.forDigit(b & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    sb.append(ch);
                }
                charArrayWriter.reset();
                needToChange = true;
            }
        }
        return needToChange ? sb.toString() : s;
    }

    public static String encode(String s) {
        return UrlUtils.encode(s, StandardCharsets.UTF_8);
    }

    public static String decode(String s, Charset charset) {
        Assert.notNull((Object)s, (String)"'s' must not be null");
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        boolean needToChange = false;
        byte[] bytes = null;
        int i = 0;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, charset));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    public static String decode(String s) {
        return UrlUtils.decode(s, StandardCharsets.UTF_8);
    }

    @NonNull
    public static String joinQueryString(@NonNull String urlOrPath, Map<String, String> queryStringMap) {
        String hashParam;
        Assert.notNull((Object)urlOrPath, (String)"'urlOrPath' must not be null");
        if (MapUtils.isEmpty(queryStringMap)) {
            return urlOrPath;
        }
        int idx = urlOrPath.indexOf(35);
        if (idx == 0) {
            hashParam = urlOrPath;
        } else if (idx > 0) {
            hashParam = urlOrPath.substring(idx);
            urlOrPath = urlOrPath.substring(0, idx);
        } else {
            hashParam = null;
        }
        boolean isFirstParam = true;
        char firstParamSplicerChar = StringUtils.contains(urlOrPath, '?') ? (char)'&' : '?';
        StringBuilder sb = new StringBuilder(urlOrPath);
        urlOrPath = null;
        for (Map.Entry<String, String> kv : queryStringMap.entrySet()) {
            if (isFirstParam) {
                sb.append(firstParamSplicerChar);
                isFirstParam = false;
            } else {
                sb.append('&');
            }
            sb.append(UrlUtils.encode(kv.getKey())).append('=');
            if (kv.getValue() == null) continue;
            sb.append(UrlUtils.encode(kv.getValue()));
        }
        if (hashParam != null) {
            sb.append(hashParam);
        }
        return sb.toString();
    }

    static {
        int i;
        DONT_NEED_URL_ENCODE = new BitSet(128);
        for (i = 97; i <= 122; ++i) {
            DONT_NEED_URL_ENCODE.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            DONT_NEED_URL_ENCODE.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            DONT_NEED_URL_ENCODE.set(i);
        }
        DONT_NEED_URL_ENCODE.set(32);
        DONT_NEED_URL_ENCODE.set(45);
        DONT_NEED_URL_ENCODE.set(95);
        DONT_NEED_URL_ENCODE.set(46);
        DONT_NEED_URL_ENCODE.set(42);
    }
}

