/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.jar;

import cn.hutool.core.io.IORuntimeException;
import icu.easyj.core.exception.MultipleFilesFoundException;
import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.ResourceUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.version.VersionInfo;
import icu.easyj.core.util.version.VersionUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class JarContext {
    private final String jarFilePath;
    private JarFile jarFile;
    private final String name;
    private VersionInfo versionInfo;
    private final Manifest manifest;
    private final Attributes attributes;

    public JarContext(String jarFilePath, String name, VersionInfo versionInfo, Manifest manifest, Attributes attributes) {
        this.jarFilePath = jarFilePath;
        this.name = name;
        this.versionInfo = versionInfo;
        this.manifest = manifest;
        this.attributes = attributes;
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public String getName() {
        return this.name;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public void setVersion(String version) {
        this.setVersionInfo(VersionUtils.parse(version));
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attributeName) {
        return this.attributes.getValue(attributeName);
    }

    public String getAttribute(Attributes.Name attributeName) {
        return this.attributes.getValue(attributeName);
    }

    public JarFile getJarFile() {
        if (this.jarFile == null) {
            try {
                File file = org.springframework.util.ResourceUtils.getFile((String)this.jarFilePath);
                this.jarFile = new JarFile(file);
            }
            catch (IOException ioe) {
                throw new IORuntimeException("\u83b7\u53d6JAR\u6587\u4ef6\u5931\u8d25\uff1a" + this.jarFilePath, (Throwable)ioe);
            }
        }
        return this.jarFile;
    }

    @NonNull
    public Resource[] getResources(String locationPattern) {
        if (!((String)locationPattern).startsWith("!")) {
            locationPattern = !((String)locationPattern).startsWith("/") ? "!/" + (String)locationPattern : "!" + (String)locationPattern;
        }
        locationPattern = this.jarFilePath + (String)locationPattern;
        return ResourceUtils.getResources((String)locationPattern);
    }

    @Nullable
    public Resource getResource(String locationPattern) {
        Resource[] resources = this.getResources(locationPattern);
        if (ArrayUtils.isEmpty(resources)) {
            return null;
        }
        if (resources.length == 1) {
            return resources[0];
        }
        StringBuilder sb = new StringBuilder();
        for (Resource resource : resources) {
            sb.append("\r\n - ");
            try {
                sb.append(resource.getURL());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new MultipleFilesFoundException("\u901a\u8fc7\u8d44\u6e90\u8def\u5f84\u5339\u914d\u4e32 '" + locationPattern + "' \u627e\u5230\u591a\u4e2a\u8d44\u6e90\u6587\u4ef6\uff1a" + sb);
    }

    @NonNull
    public List<String> getClassNames() {
        Resource[] resources = this.getResources("/**/*.class");
        ArrayList<String> classNames = new ArrayList<String>();
        for (Resource resource : resources) {
            String resourcePath;
            try {
                resourcePath = resource.getURL().toString();
            }
            catch (IOException ignore) {
                continue;
            }
            resourcePath = resourcePath.substring(resourcePath.indexOf(".jar!/") + ".jar!/".length(), resourcePath.length() - 6);
            resourcePath = resourcePath.replace('/', '.');
            classNames.add(resourcePath);
        }
        return classNames;
    }

    @NonNull
    public Set<String> getClassPackages(int numberOfTheDot) {
        List<String> classNames = this.getClassNames();
        HashSet<String> packages = new HashSet<String>();
        for (String className : classNames) {
            int idx = StringUtils.indexOf(className, '.', numberOfTheDot);
            if (idx <= 0) continue;
            packages.add(className.substring(0, idx));
        }
        return packages;
    }
}

