/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.string.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnJavaVersion;
import icu.easyj.core.util.string.IStringService;
import icu.easyj.core.util.string.impls.StringReflection;
import org.springframework.lang.NonNull;

@LoadLevel(name="JDK8-String", order=180)
@DependsOnJavaVersion(max=1.8f)
class Jdk8StringServiceImpl
implements IStringService {
    Jdk8StringServiceImpl() {
    }

    @Override
    public char[] toCharArray(@NonNull CharSequence str) {
        return this.getValue(str);
    }

    public char[] getValue(@NonNull CharSequence str) {
        try {
            return (char[])StringReflection.STRING_VALUE_FIELD.get(str.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u83b7\u53d6\u5b57\u7b26\u4e32\u7684value\u5931\u8d25", e);
        }
    }

    @Override
    public byte getCoder(@NonNull CharSequence str) {
        char[] chars;
        for (char c : chars = this.toCharArray(str)) {
            if (c <= '\u007f') continue;
            return 1;
        }
        return 0;
    }
}

