/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.version;

import icu.easyj.core.util.version.IncompatibleVersionException;
import icu.easyj.core.util.version.VersionUtils;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.lang.NonNull;

public class VersionInfo
implements Comparable<VersionInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String version;
    private final long versionLong;
    private final boolean unknownVersion;
    private final boolean snapshotVersion;

    public VersionInfo(String version) {
        long versionLong;
        boolean unknownVersion = VersionUtils.isUnknownVersion(version);
        this.version = unknownVersion ? "<unknown>" : version;
        try {
            versionLong = VersionUtils.toLong(version);
        }
        catch (IncompatibleVersionException e) {
            unknownVersion = true;
            versionLong = -1L;
        }
        this.unknownVersion = unknownVersion;
        this.versionLong = versionLong;
        this.snapshotVersion = VersionUtils.isSnapshotVersion(version);
    }

    @Override
    public int compareTo(@NonNull VersionInfo otherVersionInfo) {
        if (otherVersionInfo == null) {
            return 1;
        }
        if (otherVersionInfo == this) {
            return 0;
        }
        if (Objects.equals(this.version, otherVersionInfo.version)) {
            return 0;
        }
        return this.compare(otherVersionInfo.getVersion(), otherVersionInfo.getVersionLong());
    }

    @Override
    public int compareTo(String otherVersion) {
        if (VersionUtils.isUnknownVersion(otherVersion)) {
            return this.unknownVersion ? 0 : 1;
        }
        if (this.unknownVersion) {
            return -1;
        }
        if (this.version.equals(otherVersion)) {
            return 0;
        }
        long otherVersionLong = VersionUtils.toLong(otherVersion);
        return this.compare(otherVersion, otherVersionLong);
    }

    private int compare(String otherVersion, long otherVersionLong) {
        int result = Long.compare(this.versionLong, otherVersionLong);
        if (result == 0) {
            return this.version.compareTo(otherVersion);
        }
        return result;
    }

    public boolean between(String startVersion, String toVersion) {
        return this.compareTo(startVersion) >= 0 && this.compareTo(toVersion) <= 0;
    }

    public boolean notBetween(String startVersion, String toVersion) {
        return !this.between(startVersion, toVersion);
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    public long getVersionLong() {
        return this.versionLong;
    }

    public boolean isUnknownVersion() {
        return this.unknownVersion;
    }

    public boolean isSnapshotVersion() {
        return this.snapshotVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo that = (VersionInfo)o;
        return this.versionLong == that.versionLong && this.unknownVersion == that.unknownVersion && this.snapshotVersion == that.snapshotVersion && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.versionLong, this.unknownVersion, this.snapshotVersion);
    }

    public String toString() {
        return "VersionInfo{version='" + this.version + "', versionLong=" + this.versionLong + ", unknownVersion=" + this.unknownVersion + ", snapshotVersion=" + this.snapshotVersion + "}";
    }
}

