/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.crypto;

import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.crypto.ICryptoGenerator;
import icu.easyj.crypto.asymmetric.IAsymmetricCrypto;
import icu.easyj.crypto.symmetric.ISymmetricCrypto;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class CryptoFactory {
    public static ICryptoGenerator getGenerator() {
        return CryptoGeneratorSingletonHolder.INSTANCE.getInstance();
    }

    public static ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull SecretKey secretKey, @Nullable AlgorithmParameterSpec algorithmParameterSpec) {
        return CryptoFactory.getGenerator().getSymmetricCrypto(algorithm, secretKey, algorithmParameterSpec);
    }

    public static ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull byte[] key, byte[] iv) {
        return CryptoFactory.getGenerator().getSymmetricCrypto(algorithm, key, iv);
    }

    public static ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull String key, @Nullable String iv) {
        return CryptoFactory.getGenerator().getSymmetricCrypto(algorithm, key, iv);
    }

    public static ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull String key, String iv, Charset charset) {
        return CryptoFactory.getGenerator().getSymmetricCrypto(algorithm, key, iv, charset);
    }

    public IAsymmetricCrypto getAsymmetricCrypto(@NonNull String algorithm, @NonNull PublicKey publicKey, @NonNull PrivateKey privateKey) {
        return CryptoFactory.getGenerator().getAsymmetricCrypto(algorithm, publicKey, privateKey);
    }

    public static IAsymmetricCrypto getAsymmetricCrypto(String algorithm, byte[] publicKey, byte[] privateKey) {
        return CryptoFactory.getGenerator().getAsymmetricCrypto(algorithm, publicKey, privateKey);
    }

    public static IAsymmetricCrypto getAsymmetricCrypto(String algorithm, String publicKeyStr, String privateKeyStr) {
        return CryptoFactory.getGenerator().getAsymmetricCrypto(algorithm, publicKeyStr, privateKeyStr);
    }

    private static enum CryptoGeneratorSingletonHolder {
        INSTANCE;

        private final ICryptoGenerator instance = EnhancedServiceLoader.load(ICryptoGenerator.class);

        public ICryptoGenerator getInstance() {
            return CryptoGeneratorSingletonHolder.INSTANCE.instance;
        }
    }
}

