/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.login;

import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.core.trace.TraceUtils;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.login.ILoginProperties;
import icu.easyj.login.ILoginTokenBuilder;
import icu.easyj.login.ILoginTokenLoader;
import icu.easyj.login.LoginInfo;
import icu.easyj.login.LoginUtils;
import icu.easyj.web.filter.FilterAdapter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;

@Order(value=-70)
public class LoginFilter
implements FilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginFilter.class);
    private static final List<ILoginTokenLoader> LOGIN_TOKEN_LOADERS = EnhancedServiceLoader.loadAll(ILoginTokenLoader.class);
    private static final String TRACE_PRE_KEY = "LOGIN_";
    private final ILoginTokenBuilder loginTokenBuilder;
    private final ILoginProperties properties;

    public LoginFilter(ILoginTokenBuilder loginTokenBuilder, ILoginProperties properties) {
        Assert.notNull((Object)loginTokenBuilder, (String)"'loginTokenBuilder' must be not null");
        Assert.notNull((Object)properties, (String)"'properties' must be not null");
        this.loginTokenBuilder = loginTokenBuilder;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HashSet<String> traceKeys = new HashSet<String>(this.properties.getTraceLoginInfos().length);
        try {
            for (ILoginTokenLoader loader : LOGIN_TOKEN_LOADERS) {
                String token = loader.load(httpRequest, this.properties);
                if (!StringUtils.isNotBlank(token)) continue;
                LoginInfo<?, ?> loginInfo = this.loginTokenBuilder.parse(token);
                LoginUtils.setLoginInfo(loginInfo);
                if (!this.properties.isNeedTraceLoginInfo()) break;
                for (String traceLoginInfo : this.properties.getTraceLoginInfos()) {
                    try {
                        Object loginInfoFieldValue = ReflectionUtils.getFieldValue(loginInfo, traceLoginInfo);
                        String traceKey = TRACE_PRE_KEY + traceLoginInfo;
                        traceKeys.add(traceKey);
                        TraceUtils.put(traceKey, String.valueOf(loginInfoFieldValue));
                    }
                    catch (NoSuchFieldException e) {
                        LOGGER.warn("\u4e0d\u5b58\u5728\u767b\u5f55\u4fe1\u606f '{}'\uff0c\u65e0\u6cd5\u6dfb\u52a0\u8ffd\u8e2a\u4fe1\u606f", (Object)traceLoginInfo);
                    }
                }
            }
            chain.doFilter(request, response);
        }
        finally {
            LoginUtils.clear();
            TraceUtils.remove(traceKeys);
        }
    }
}

