/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.redis.sequence.impls;

import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.core.util.MapUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SpringRedisSequenceServiceImpl
implements ISequenceService {
    private final RedisConnectionFactory connectionFactory;
    @Nullable
    private final Long initialValue;
    private final Map<String, RedisAtomicLong> redisAtomicLongMap;

    public SpringRedisSequenceServiceImpl(RedisConnectionFactory connectionFactory, @Nullable Long initialValue) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must be not null");
        this.connectionFactory = connectionFactory;
        this.initialValue = initialValue;
        this.redisAtomicLongMap = new ConcurrentHashMap<String, RedisAtomicLong>();
    }

    public SpringRedisSequenceServiceImpl(RedisConnectionFactory connectionFactory) {
        this(connectionFactory, null);
    }

    @Override
    public long nextVal(@NonNull String seqName) {
        return this.getRedisAtomicLong(seqName).incrementAndGet();
    }

    @Override
    public long currVal(@NonNull String seqName) {
        return this.getRedisAtomicLong(seqName).get();
    }

    @Override
    public long setVal(@NonNull String seqName, long newVal) {
        return this.getRedisAtomicLong(seqName).getAndSet(newVal);
    }

    private RedisAtomicLong getRedisAtomicLong(String seqName) {
        return MapUtils.computeIfAbsent(this.redisAtomicLongMap, seqName, k -> {
            if (this.initialValue != null) {
                return new RedisAtomicLong(seqName, this.connectionFactory, this.initialValue.longValue());
            }
            return new RedisAtomicLong(seqName, this.connectionFactory);
        });
    }
}

