/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.param.crypto;

import icu.easyj.core.util.StringUtils;
import icu.easyj.web.filter.AbstractFilter;
import icu.easyj.web.param.crypto.IParamCryptoFilterProperties;
import icu.easyj.web.param.crypto.IParamCryptoHandler;
import icu.easyj.web.param.crypto.IParamCryptoHandlerProperties;
import icu.easyj.web.param.crypto.exception.ParamDecryptException;
import icu.easyj.web.param.crypto.exception.ParamNotEncryptedException;
import icu.easyj.web.util.HttpUtils;
import icu.easyj.web.wrapper.QueryStringHttpServletRequestWrapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

@Order(value=-75)
public class ParamCryptoFilter
extends AbstractFilter<IParamCryptoFilterProperties> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamCryptoFilter.class);
    private final IParamCryptoHandlerProperties cryptoHandlerProperties;
    private final IParamCryptoHandler cryptoHandler;

    public ParamCryptoFilter(@NonNull IParamCryptoFilterProperties filterProperties, @NonNull IParamCryptoHandlerProperties cryptoHandlerProperties, @NonNull IParamCryptoHandler cryptoHandler) {
        super(filterProperties);
        Assert.notNull((Object)cryptoHandler, (String)"'cryptoHandler' must not be null");
        Assert.notNull((Object)cryptoHandlerProperties, (String)"'cryptoHandlerProperties' must not be null");
        this.cryptoHandlerProperties = cryptoHandlerProperties;
        this.cryptoHandler = cryptoHandler;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (HttpUtils.isInternalRequest() || !super.isNeedDoFilter(request)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        request = this.decryptQueryString(request);
        filterChain.doFilter((ServletRequest)request, servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpServletRequest decryptQueryString(HttpServletRequest request) {
        String encryptedQueryString = this.getEncryptedQueryString(request);
        if (StringUtils.isEmpty(encryptedQueryString)) {
            return request;
        }
        if (!this.cryptoHandlerProperties.isNeedEncryptInputParam() && !this.cryptoHandler.isEncryptedQueryString(encryptedQueryString)) {
            return request;
        }
        try {
            String queryString = this.cryptoHandler.decrypt(encryptedQueryString);
            LOGGER.debug("QueryString\u5165\u53c2\u89e3\u5bc6\u6210\u529f\uff01\r\n==>\r\n\u89e3\u5bc6\u524d: {}\r\n\u89e3\u5bc6\u540e: {}\r\n<==", (Object)encryptedQueryString, (Object)queryString);
            QueryStringHttpServletRequestWrapper queryStringHttpServletRequestWrapper = new QueryStringHttpServletRequestWrapper(request, queryString);
            return queryStringHttpServletRequestWrapper;
        }
        catch (RuntimeException e) {
            LOGGER.error("QueryString\u5165\u53c2\u672a\u52a0\u5bc6\u6216\u683c\u5f0f\u6709\u8bef\uff0c\u89e3\u5bc6\u5931\u8d25\uff01\r\n==>\r\nQuery String: {}\r\nErrorMessage: {}\r\n<==", (Object)request.getQueryString(), (Object)e.getMessage());
            if (this.cryptoHandlerProperties.isNeedEncryptInputParam()) {
                throw new ParamDecryptException("QueryString\u5165\u53c2\u672a\u52a0\u5bc6\u6216\u683c\u5f0f\u6709\u8bef\uff0c\u89e3\u5bc6\u5931\u8d25", "DECRYPT_FAILED", e);
            }
            LOGGER.warn("QueryString\u5c1d\u8bd5\u89e3\u5bc6\u5931\u8d25\uff0cQueryString\uff1a{}", (Object)encryptedQueryString, (Object)e);
            HttpServletRequest httpServletRequest = request;
            return httpServletRequest;
        }
        finally {
            encryptedQueryString = null;
        }
    }

    private String getEncryptedQueryString(HttpServletRequest request) {
        if (StringUtils.isNotEmpty(((IParamCryptoFilterProperties)this.filterProperties).getQueryStringName())) {
            Map parameterMap;
            if (this.cryptoHandlerProperties.isNeedEncryptInputParam() && (parameterMap = request.getParameterMap()) != null && parameterMap.size() > 1) {
                HashSet parameterNames = new HashSet(parameterMap.keySet());
                parameterNames.remove(((IParamCryptoFilterProperties)this.filterProperties).getQueryStringName());
                String errorMsg = "\u5b58\u5728\u672a\u52a0\u5bc6\u7684\u53c2\u6570\uff1a" + StringUtils.toString(parameterNames);
                parameterNames.clear();
                parameterNames = null;
                LOGGER.info("{}, queryString: {}", (Object)errorMsg, (Object)request.getQueryString());
                throw new ParamNotEncryptedException(errorMsg, "HAS_UN_ENCRYPTED_QUERY_STRING");
            }
            return request.getParameter(((IParamCryptoFilterProperties)this.filterProperties).getQueryStringName());
        }
        return request.getQueryString();
    }

    public IParamCryptoHandlerProperties getCryptoHandlerProperties() {
        return this.cryptoHandlerProperties;
    }

    public IParamCryptoHandler getCryptoHandler() {
        return this.cryptoHandler;
    }
}

