/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.util;

import icu.easyj.core.util.StringUtils;
import icu.easyj.web.exception.RequestContextNotFoundException;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class HttpUtils {
    private static final ThreadLocal<Boolean> INTERNAL_REQUEST_FLAG = new ThreadLocal();

    @NonNull
    public static HttpServletRequest getRequest() throws RequestContextNotFoundException {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new RequestContextNotFoundException();
        }
        return requestAttributes.getRequest();
    }

    @NonNull
    public static HttpServletResponse getResponse() throws RequestContextNotFoundException {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new RequestContextNotFoundException();
        }
        HttpServletResponse response = requestAttributes.getResponse();
        if (response == null) {
            throw new RequestContextNotFoundException();
        }
        return response;
    }

    public static String getContextPath(@NonNull ServletContext context) {
        String contextPath = context.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            return "/";
        }
        return contextPath;
    }

    @NonNull
    public static String getNoContextPathUri(String uri, @Nullable String contextPath) {
        if (uri == null) {
            return "/";
        }
        if (contextPath == null || contextPath.isEmpty() || "/".equals(contextPath)) {
            return uri;
        }
        if (uri.startsWith(contextPath)) {
            uri = uri.substring(contextPath.length());
        }
        return uri;
    }

    public static boolean isHttp(@NonNull String url) {
        url = url.toLowerCase();
        return url.startsWith("http://");
    }

    public static boolean isHttps(@NonNull String url) {
        url = url.toLowerCase();
        return url.startsWith("https://");
    }

    public static boolean isHttpOrHttps(@NonNull String url) {
        return (url = url.toLowerCase()).startsWith("http://") || url.startsWith("https://");
    }

    public static boolean isGetRequest(HttpServletRequest request) {
        return HttpMethod.GET.name().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isGetRequest() {
        return HttpUtils.isGetRequest(HttpUtils.getRequest());
    }

    public static boolean isNotGetRequest(HttpServletRequest request) {
        return !HttpUtils.isGetRequest(request);
    }

    public static boolean isNotGetRequest() {
        return !HttpUtils.isGetRequest();
    }

    public static boolean isPostRequest(HttpServletRequest request) {
        return HttpMethod.POST.name().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPostRequest() {
        return HttpUtils.isPostRequest(HttpUtils.getRequest());
    }

    public static boolean isNotPostRequest(HttpServletRequest request) {
        return !HttpUtils.isPostRequest(request);
    }

    public static boolean isNotPostRequest() {
        return !HttpUtils.isPostRequest();
    }

    public static boolean isOptionsRequest(HttpServletRequest request) {
        return HttpMethod.OPTIONS.name().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isOptionsRequest() {
        return HttpUtils.isOptionsRequest(HttpUtils.getRequest());
    }

    public static boolean isNotOptionsRequest(HttpServletRequest request) {
        return !HttpUtils.isOptionsRequest(request);
    }

    public static boolean isNotOptionsRequest() {
        return !HttpUtils.isOptionsRequest();
    }

    public static boolean isNoCacheRequest(HttpServletRequest request) {
        String cacheControl = request.getHeader("Cache-Control");
        if (StringUtils.isNotEmpty(cacheControl)) {
            return (cacheControl = cacheControl.toLowerCase()).contains("no-cache") || cacheControl.contains("no-store");
        }
        return false;
    }

    public static boolean isNoCacheRequest() {
        return HttpUtils.isNoCacheRequest(HttpUtils.getRequest());
    }

    public static boolean isInternalRequest() {
        return Boolean.TRUE.equals(INTERNAL_REQUEST_FLAG.get());
    }

    public static void setInternalRequest() {
        INTERNAL_REQUEST_FLAG.set(true);
    }

    public static void clearInternalRequest() {
        INTERNAL_REQUEST_FLAG.remove();
    }

    public static void setResponseStatus304(HttpServletResponse response) {
        response.setStatus(HttpStatus.NOT_MODIFIED.value());
    }

    public static void setResponseStatus304() {
        HttpUtils.setResponseStatus304(HttpUtils.getResponse());
    }

    public static void setResponseNotAllowCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static boolean isDoExportRequest(HttpServletRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("doExport"));
    }

    public static boolean isDoExportRequest() {
        return HttpUtils.isDoExportRequest(HttpUtils.getRequest());
    }

    public static String generateExportFileName(@NonNull String fileNamePre, String fileSuffix) {
        if (!((String)fileNamePre).endsWith("_")) {
            fileNamePre = (String)fileNamePre + "_";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return (String)fileNamePre + sdf.format(new Date()) + (Serializable)(fileSuffix.charAt(0) != '.' ? Character.valueOf('.') : "") + fileSuffix;
    }
}

