/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package icu.easyj.core.convert.converter;

import java.util.Date;

import icu.easyj.core.util.DateUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

/**
 * 时间转换为字符串的转换器
 *
 * @author wangliang181230
 */
public class DateToStringConverter implements Converter<Date, String> {

	@Nullable
	@Override
	public String convert(Date source) {
		if (source != null) {
			return DateUtils.toString(source);
		} else {
			return null;
		}
	}
}
