/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.util;

import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.poi.hssf.util.HSSFColor;

public abstract class ExcelColorUtils {
    public static final short TEAL_INDEX = 21;

    public static short getColorIndex(String color) {
        if (StringUtils.isEmpty(color)) {
            return 0;
        }
        try {
            ?[] colors;
            Class<?> hssfColorPredefinedClass = Class.forName(HSSFColor.class.getName() + "$HSSFColorPredefined");
            for (Object colorEnum : colors = hssfColorPredefinedClass.getEnumConstants()) {
                if (!colorEnum.toString().equalsIgnoreCase(color)) continue;
                try {
                    return (Short)ReflectionUtils.invokeMethod(colorEnum, "getIndex");
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        catch (ClassNotFoundException e) {
            Collection colorList = HSSFColor.getTripletHash().values();
            for (HSSFColor hssfColor : colorList) {
                if (!hssfColor.getClass().getSimpleName().equalsIgnoreCase(color)) continue;
                return hssfColor.getIndex();
            }
        }
        short colorIndexRet = 0;
        String colorHex = color;
        if (colorHex.contains("#")) {
            colorHex = StringUtils.remove(colorHex, '#');
        }
        if (colorHex.length() == 3) {
            colorHex = "" + colorHex.charAt(0) + colorHex.charAt(0) + colorHex.charAt(1) + colorHex.charAt(1) + colorHex.charAt(2) + colorHex.charAt(2);
        }
        if (colorHex.length() == 6) {
            Color awtColor = Color.getColor(null, Integer.valueOf(colorHex, 16));
            for (Integer colorIndex : HSSFColor.getIndexHash().keySet()) {
                HSSFColor hssfColor = (HSSFColor)HSSFColor.getIndexHash().get(colorIndex);
                short[] triplet = hssfColor.getTriplet();
                if (triplet == null || triplet.length < 3 || awtColor.getRed() != triplet[0] || awtColor.getGreen() != triplet[1] || awtColor.getBlue() != triplet[2]) continue;
                colorIndexRet = Short.parseShort(colorIndex.toString());
                break;
            }
        }
        return colorIndexRet;
    }
}

