/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.util;

import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.poi.excel.annotation.ExcelCell;
import icu.easyj.poi.excel.hook.ListToExcelHookTrigger;
import icu.easyj.poi.excel.model.ExcelMapping;
import icu.easyj.poi.excel.util.ExcelCellUtils;
import icu.easyj.poi.excel.util.ExcelContext;
import icu.easyj.poi.excel.util.ExcelRowUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public abstract class ExcelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelUtils.class);

    public static <T> List<T> toList(Workbook book, Class<T> clazz, Predicate<T> validDataFun) throws Exception {
        Sheet sheet = ExcelUtils.getHasDataSheet(book);
        if (sheet == null) {
            return new ArrayList();
        }
        ExcelMapping mapping = ExcelMapping.getMapping(clazz);
        int rowStart = sheet.getFirstRowNum();
        int rowEnd = sheet.getPhysicalNumberOfRows() - 1;
        while (ExcelRowUtils.isEmptyRow(sheet.getRow(rowStart))) {
            if (++rowStart <= rowEnd) continue;
            return new ArrayList();
        }
        if (rowStart > rowEnd) {
            return new ArrayList();
        }
        if (rowStart < 0) {
            return new ArrayList();
        }
        Integer headRowNum = ExcelUtils.findHeadRowNum(sheet, rowStart, mapping);
        if (headRowNum != null && (rowStart = headRowNum + 1) > rowEnd) {
            return new ArrayList();
        }
        boolean hasNumberCell = ExcelUtils.getHasNumberCell(sheet, mapping);
        ArrayList<T> result = new ArrayList<T>();
        Row headRow = headRowNum != null ? sheet.getRow(headRowNum.intValue()) : null;
        for (int i = rowStart; i <= rowEnd; ++i) {
            Row row = sheet.getRow(i);
            if (ExcelRowUtils.isEmptyRow(row) || row.getLastCellNum() == 1 && mapping.getCellMappingList().size() > (mapping.isNeedNumberCell() ? 1 : 2)) continue;
            T t = ExcelRowUtils.rowToObject(row, hasNumberCell, headRow, clazz, mapping);
            if (validDataFun != null && !validDataFun.test(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> toList(InputStream is, Class<T> clazz, Predicate<T> validDataFun) throws Exception {
        try (Workbook book = WorkbookFactory.create((InputStream)is);){
            List<T> list = ExcelUtils.toList(book, clazz, validDataFun);
            return list;
        }
    }

    public static <T> List<T> toList(String filePath, Class<T> clazz, Predicate<T> validDataFun) throws Exception {
        try (FileInputStream is = new FileInputStream(filePath);){
            List<T> list = ExcelUtils.toList(is, clazz, validDataFun);
            return list;
        }
    }

    public static <T> List<T> toList(Workbook book, Class<T> clazz) throws Exception {
        return ExcelUtils.toList(book, clazz, null);
    }

    public static <T> List<T> toList(InputStream is, Class<T> clazz) throws Exception {
        return ExcelUtils.toList(is, clazz, null);
    }

    public static <T> List<T> toList(String filePath, Class<T> clazz) throws Exception {
        return ExcelUtils.toList(filePath, clazz, null);
    }

    public static boolean getHasNumberCell(Sheet sheet, ExcelMapping mapping) {
        for (int i = 0; i <= sheet.getPhysicalNumberOfRows() - 1; ++i) {
            Row row = sheet.getRow(i);
            if (ExcelRowUtils.isEmptyRow(row)) continue;
            for (int j = 0; j < row.getLastCellNum(); ++j) {
                Cell cell = row.getCell(j);
                Object cellValue = ExcelCellUtils.getCellValue(cell);
                if (cellValue == null || !cellValue.equals(mapping.getNumberCellHeadName()) && !"\u5e8f\u53f7".equals(cellValue)) continue;
                return true;
            }
            break;
        }
        return false;
    }

    @Nullable
    static Integer findHeadRowNum(Sheet sheet, int firstRowNum, ExcelMapping mapping) {
        for (int i = 0; i < 3; ++i) {
            Row row = sheet.getRow(firstRowNum + i);
            if (row == null || !ExcelRowUtils.isHeadRow(row, mapping)) continue;
            return row.getRowNum();
        }
        return null;
    }

    private static Sheet generateSheet(Workbook book, List<?> dataList, ExcelMapping mapping, String sheetName) {
        ExcelContext.put("dataList", dataList);
        Sheet sheet = StringUtils.isBlank(sheetName) ? book.createSheet() : book.createSheet(sheetName);
        ExcelCellUtils.setCellStyle(sheet, mapping, -1, true);
        ListToExcelHookTrigger.onBeforeCreateHeadRow(sheet, mapping);
        int firstRowNum = sheet.getPhysicalNumberOfRows();
        ExcelRowUtils.createHeadRow(sheet, mapping);
        if (CollectionUtils.isNotEmpty(dataList)) {
            ExcelRowUtils.createDataRows(sheet, dataList, mapping);
            ExcelRowUtils.mergeSameCells(sheet, dataList, mapping);
        }
        ListToExcelHookTrigger.onAfterCreateDataRows(sheet, mapping);
        ExcelCellUtils.setCellStyle(sheet, mapping, firstRowNum, false);
        return sheet;
    }

    public static Workbook toExcel(List<?> dataList, Class<?> clazz) {
        ExcelMapping mapping;
        if (clazz == null) {
            if (CollectionUtils.isEmpty(dataList)) {
                throw new RuntimeException("\u6570\u636e\u4e3a\u7a7a\u4e14\u7c7b\u578b\u672a\u77e5\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aexcel\u6587\u4ef6");
            }
            clazz = dataList.get(0).getClass();
        }
        if (CollectionUtils.isEmpty((mapping = ExcelMapping.getMapping(clazz)).getCellMappingList())) {
            throw new RuntimeException("\u201c" + clazz.getName() + "\u201d \u7c7b\u4e2d\u672a\u4f7f\u7528@" + ExcelCell.class.getSimpleName() + "\u914d\u7f6e\u4efb\u4f55\u5217\u4fe1\u606f");
        }
        HSSFWorkbook book = null;
        try {
            book = new HSSFWorkbook();
            ExcelUtils.generateSheet((Workbook)book, dataList, mapping, mapping.getSheetName());
        }
        catch (Exception e) {
            try {
                if (book != null) {
                    book.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.error("\u6570\u636e\u8f6c\u6362\u4e3aexcel\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6570\u636e\u8f6c\u6362\u4e3aexcel\u5931\u8d25", e);
        }
        finally {
            ExcelContext.remove("dataList");
        }
        return book;
    }

    public static <T> void saveToExcelFile(List<T> dataList, Class<T> clazz, String filePath) throws IOException {
        try (Workbook book = ExcelUtils.toExcel(dataList, clazz);){
            File file = new File(filePath);
            try (FileOutputStream fos = new FileOutputStream(file);){
                book.write((OutputStream)fos);
                fos.flush();
            }
        }
    }

    @Nullable
    public static Class<?> getClassFromMap(Map<String, List<?>> dataMap) {
        if (!dataMap.isEmpty()) {
            for (List<?> list : dataMap.values()) {
                if (list.isEmpty()) continue;
                return list.get(0).getClass();
            }
        }
        return null;
    }

    public static Workbook toExcel(Map<String, List<?>> dataMap, Class<?> clazz) {
        ExcelMapping mapping;
        if (clazz == null) {
            if (CollectionUtils.isEmpty(dataMap)) {
                throw new RuntimeException("\u6570\u636e\u4e3a\u7a7a\u4e14\u7c7b\u578b\u672a\u77e5\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aexcel\u6587\u4ef6");
            }
            clazz = ExcelUtils.getClassFromMap(dataMap);
            if (clazz == null) {
                throw new RuntimeException("\u6570\u636e\u4e3a\u7a7a\u4e14\u7c7b\u578b\u672a\u77e5\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aexcel\u6587\u4ef6");
            }
        }
        if (CollectionUtils.isEmpty((mapping = ExcelMapping.getMapping(clazz)).getCellMappingList())) {
            throw new RuntimeException("\u201c" + clazz.getName() + "\u201d \u7c7b\u4e2d\u672a\u4f7f\u7528@" + ExcelCell.class.getSimpleName() + "\u914d\u7f6e\u4efb\u4f55\u5217\u4fe1\u606f");
        }
        HSSFWorkbook book = null;
        try {
            book = new HSSFWorkbook();
            for (Map.Entry<String, List<?>> entry : dataMap.entrySet()) {
                String sheetName = entry.getKey();
                List dataList = entry.getValue() == null ? Collections.emptyList() : entry.getValue();
                ExcelUtils.generateSheet((Workbook)book, dataList, mapping, sheetName);
            }
        }
        catch (Exception e) {
            try {
                if (book != null) {
                    book.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.error("\u6570\u636e\u8f6c\u6362\u4e3aexcel\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("\u6570\u636e\u8f6c\u6362\u4e3aexcel\u5931\u8d25", e);
        }
        finally {
            ExcelContext.remove("dataList");
        }
        return book;
    }

    @Nullable
    public static Sheet getHasDataSheet(Workbook book) {
        if (book == null) {
            return null;
        }
        for (int i = 0; i < book.getNumberOfSheets(); ++i) {
            Sheet sheet = book.getSheetAt(i);
            if (sheet.getPhysicalNumberOfRows() <= 0) continue;
            return sheet;
        }
        return null;
    }
}

