/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.baidu.cloud.dwz;

import cn.hutool.core.annotation.Alias;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzErrorType;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzResponseData;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class BaiduDwzResponse {
    @Alias(value="Code")
    private Integer code;
    @Alias(value="ErrMsg")
    private String errMsg;
    @Alias(value="ShortUrls")
    private List<BaiduDwzResponseData> shortUrls;

    public boolean isSuccess() {
        return this.code != null && this.code.equals(0);
    }

    @Nullable
    public BaiduDwzErrorType getErrorType() {
        return BaiduDwzErrorType.getByCode(this.code);
    }

    public String getErrorMessage() {
        if (this.code != null && BaiduDwzErrorType.PART_LONG_URL_ERROR.getCode() == this.code.intValue() && this.shortUrls != null) {
            for (BaiduDwzResponseData data : this.shortUrls) {
                if (!StringUtils.hasText((String)data.getErrMsg())) continue;
                return "[" + this.code + "]" + data.getErrMsg();
            }
        }
        return "[" + this.code + "]" + this.errMsg;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public List<BaiduDwzResponseData> getShortUrls() {
        return this.shortUrls;
    }

    public void setShortUrls(List<BaiduDwzResponseData> shortUrls) {
        this.shortUrls = shortUrls;
    }
}

