/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.baidu.cloud.dwz;

import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzConfig;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzErrorType;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzRequest;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzResponse;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzResponseData;
import icu.easyj.sdk.dwz.DwzRequest;
import icu.easyj.sdk.dwz.DwzResponse;
import icu.easyj.sdk.dwz.DwzSdkClientException;
import icu.easyj.sdk.dwz.DwzSdkException;
import icu.easyj.sdk.dwz.DwzSdkServerException;
import icu.easyj.sdk.dwz.IDwzTemplate;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;

public class BaiduDwzTemplateImpl
implements IDwzTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiduDwzTemplateImpl.class);
    private final BaiduDwzConfig config;
    private final RestTemplate restTemplate;

    public BaiduDwzTemplateImpl(BaiduDwzConfig config) {
        Assert.notNull((Object)config, (String)"'config' must not be null", (Object[])new Object[0]);
        this.config = config;
        this.restTemplate = new RestTemplate();
        ((DefaultUriBuilderFactory)this.restTemplate.getUriTemplateHandler()).setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DwzResponse createShortUrl(DwzRequest request) throws DwzSdkException {
        DwzResponse dwzResponse;
        Throwable t;
        String respStr;
        String body;
        long startTime;
        block13: {
            Assert.notNull((Object)request, (String)"'request' must not be null", (Object[])new Object[0]);
            Assert.notNull((Object)request.getLongUrl(), (String)"'longUrl' must not be null", (Object[])new Object[0]);
            startTime = System.nanoTime();
            body = null;
            respStr = null;
            t = null;
            try {
                ArrayList<BaiduDwzRequest> reqList = new ArrayList<BaiduDwzRequest>();
                BaiduDwzRequest req1 = this.buildRequest(request.getLongUrl(), request.getConfig("termOfValidity"));
                reqList.add(req1);
                body = JSONUtil.toJsonStr(reqList);
                HttpHeaders headers = new HttpHeaders();
                headers.add("Dwz-Token", this.config.getToken());
                headers.add("Content-Language", this.config.getResponseLanguage());
                HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
                try {
                    ResponseEntity respEntity = this.restTemplate.postForEntity(this.config.getServiceUrl(), (Object)httpEntity, String.class, new Object[0]);
                    respStr = (String)respEntity.getBody();
                }
                catch (RestClientResponseException e) {
                    respStr = e.getResponseBodyAsString();
                    if (!respStr.startsWith("{")) {
                        respStr = "[" + e.getRawStatusCode() + "]" + respStr;
                        throw new DwzSdkServerException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u5931\u8d25\uff1a[" + e.getRawStatusCode() + "]" + e.getMessage(), "SERVER_ERROR", (Throwable)e);
                    }
                }
                catch (RuntimeException e) {
                    throw new DwzSdkServerException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u5931\u8d25", "SERVER_ERROR", (Throwable)e);
                }
                if (StringUtils.isEmpty((CharSequence)respStr)) {
                    throw new DwzSdkServerException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u65e0\u54cd\u5e94", "EMPTY_RESPONSE");
                }
                BaiduDwzResponse resp = (BaiduDwzResponse)JSONUtil.toBean((String)respStr, BaiduDwzResponse.class);
                if (!resp.isSuccess()) {
                    BaiduDwzErrorType errorType = resp.getErrorType();
                    String errorMsg = resp.getErrorMessage();
                    String errorCode = errorType != null ? errorType.name() : resp.getCode().toString();
                    throw new DwzSdkServerException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u5931\u8d25\uff1a" + errorMsg, errorCode);
                }
                if (CollectionUtils.isEmpty(resp.getShortUrls())) {
                    throw new DwzSdkServerException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u7684\u54cd\u5e94\u4e2d\u65e0\u6570\u636e", "NO_DATA");
                }
                dwzResponse = this.convertToStandard(resp, req1.getTermOfValidity());
                if (t != null) break block13;
            }
            catch (DwzSdkException e) {
                try {
                    t = e;
                    throw e;
                    catch (RuntimeException e2) {
                        t = e2;
                        throw new DwzSdkClientException("\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u672a\u77e5\u5f02\u5e38", "UNKNOWN_ERROR", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (t == null) {
                        if (!LOGGER.isInfoEnabled()) throw throwable;
                        LOGGER.info("\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u6210\u529f\uff1a\r\n -  url: {}\r\n - body: {}\r\n - resp: {}\r\n - cost: {} ms", new Object[]{this.config.getServiceUrl(), body, respStr, Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f)});
                        throw throwable;
                    }
                    if (!LOGGER.isErrorEnabled()) throw throwable;
                    LOGGER.error("\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a{}\r\n -  url: {}\r\n - body: {}\r\n - resp: {}\r\n - cost: {} ms", new Object[]{t.getMessage(), this.config.getServiceUrl(), body, respStr, Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f)});
                    throw throwable;
                }
            }
            if (!LOGGER.isInfoEnabled()) return dwzResponse;
            LOGGER.info("\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u6210\u529f\uff1a\r\n -  url: {}\r\n - body: {}\r\n - resp: {}\r\n - cost: {} ms", new Object[]{this.config.getServiceUrl(), body, respStr, Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f)});
            return dwzResponse;
        }
        if (!LOGGER.isErrorEnabled()) return dwzResponse;
        LOGGER.error("\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a{}\r\n -  url: {}\r\n - body: {}\r\n - resp: {}\r\n - cost: {} ms", new Object[]{t.getMessage(), this.config.getServiceUrl(), body, respStr, Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f)});
        return dwzResponse;
    }

    private BaiduDwzRequest buildRequest(String longUrl, String termOfValidity) {
        BaiduDwzRequest req = new BaiduDwzRequest(longUrl, termOfValidity);
        if (StringUtils.isBlank((CharSequence)req.getTermOfValidity())) {
            req.setTermOfValidity(this.config.getDefaultTermOfValidity());
        }
        return req;
    }

    private DwzResponse convertToStandard(BaiduDwzResponse resp, String termOfValidity) {
        DwzResponse response = new DwzResponse();
        BaiduDwzResponseData data = resp.getShortUrls().get(0);
        response.setShortUrl(data.getShortUrl());
        response.setCreateTime(new Date());
        if (termOfValidity != null) {
            switch (termOfValidity) {
                case "1-year": {
                    response.setExpireIn(Long.valueOf(31536000000L));
                    break;
                }
                default: {
                    response.setExpireIn(Long.valueOf(0L));
                    break;
                }
            }
        } else {
            response.setExpireIn(Long.valueOf(0L));
        }
        return response;
    }
}

