/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.config;

import icu.easyj.core.env.EnvironmentType;
import icu.easyj.core.env.RunMode;

public class EnvironmentConfigs {
    private String env;
    private String envName;
    private EnvironmentType envType = EnvironmentType.PROD;
    private RunMode runMode = RunMode.RELEASE;
    private boolean inUnitTest = false;

    private EnvironmentConfigs() {
    }

    private static EnvironmentConfigs getInstance() {
        return SingletonHolder.INSTANCE.getConfigs();
    }

    public static String getEnv() {
        return EnvironmentConfigs.getInstance().env;
    }

    public static String getEnvName() {
        return EnvironmentConfigs.getInstance().envName;
    }

    public static EnvironmentType getEnvType() {
        return EnvironmentConfigs.getInstance().envType;
    }

    public static boolean isProdEnv() {
        return EnvironmentType.PROD == EnvironmentConfigs.getEnvType();
    }

    public static boolean isNotProdEnv() {
        return !EnvironmentConfigs.isProdEnv();
    }

    public static boolean isSandboxEnv() {
        return EnvironmentType.SANDBOX == EnvironmentConfigs.getEnvType();
    }

    public static boolean isNotSandboxEnv() {
        return !EnvironmentConfigs.isSandboxEnv();
    }

    public static boolean isTestEnv() {
        return EnvironmentType.TEST == EnvironmentConfigs.getEnvType();
    }

    public static boolean isNotTestEnv() {
        return !EnvironmentConfigs.isTestEnv();
    }

    public static boolean isDevEnv() {
        return EnvironmentType.DEV == EnvironmentConfigs.getEnvType();
    }

    public static boolean isNotDevEnv() {
        return !EnvironmentConfigs.isDevEnv();
    }

    public static RunMode getRunMode() {
        return EnvironmentConfigs.getInstance().runMode;
    }

    public static boolean isReleaseMode() {
        return RunMode.RELEASE == EnvironmentConfigs.getRunMode();
    }

    public static boolean isDebugMode() {
        return RunMode.DEBUG == EnvironmentConfigs.getRunMode();
    }

    public static boolean isInUnitTest() {
        return EnvironmentConfigs.getInstance().inUnitTest;
    }

    public static void setEnv(String env) {
        EnvironmentConfigs.getInstance().env = env;
    }

    public static void setEnvName(String envName) {
        EnvironmentConfigs.getInstance().envName = envName;
    }

    public static void setEnvType(EnvironmentType envType) {
        EnvironmentConfigs.getInstance().envType = envType;
    }

    public static void setRunMode(RunMode runMode) {
        EnvironmentConfigs.getInstance().runMode = runMode;
    }

    public static void setInUnitTest(boolean inUnitTest) {
        EnvironmentConfigs.getInstance().inUnitTest = inUnitTest;
    }

    private static enum SingletonHolder {
        INSTANCE;

        private final EnvironmentConfigs configs = new EnvironmentConfigs();

        public EnvironmentConfigs getConfigs() {
            return this.configs;
        }
    }
}

