/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.config;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import icu.easyj.core.util.NetUtils;
import icu.easyj.core.util.StringUtils;

public class ServerConfigs {
    private String host = NetUtils.getIp();
    private String domain;
    private Long workerId;
    private Long dataCenterId;
    private Snowflake snowflake;

    private ServerConfigs() {
    }

    private static ServerConfigs getInstance() {
        return SingletonHolder.INSTANCE.getConfigs();
    }

    public static void init() {
        Long dataCenterId = ServerConfigs.getDataCenterId();
        Long workerId = ServerConfigs.getWorkerId();
        if (dataCenterId == null) {
            dataCenterId = IdUtil.getDataCenterId((long)31L);
            ServerConfigs.setDataCenterId(dataCenterId);
        }
        if (workerId == null) {
            workerId = IdUtil.getWorkerId((long)dataCenterId, (long)31L);
            ServerConfigs.setWorkerId(dataCenterId);
        }
        ServerConfigs.setSnowflake(new Snowflake(workerId.longValue(), dataCenterId.longValue()));
    }

    public static String getHost() {
        return ServerConfigs.getInstance().host;
    }

    public static void setHost(String host) {
        ServerConfigs.getInstance().host = host;
    }

    public static String getDomain() {
        return ServerConfigs.getInstance().domain;
    }

    public static void setDomain(String domain) {
        if (domain != null) {
            domain = StringUtils.trimEnd((String)domain, (char)'/');
        }
        ServerConfigs.getInstance().domain = domain;
    }

    public static Long getWorkerId() {
        return ServerConfigs.getInstance().workerId;
    }

    public static void setWorkerId(Long workerId) {
        ServerConfigs.getInstance().workerId = workerId;
    }

    public static Long getDataCenterId() {
        return ServerConfigs.getInstance().dataCenterId;
    }

    public static void setDataCenterId(Long dataCenterId) {
        ServerConfigs.getInstance().dataCenterId = dataCenterId;
    }

    public static Snowflake getSnowflake() {
        return ServerConfigs.getInstance().snowflake;
    }

    public static void setSnowflake(Snowflake snowflake) {
        ServerConfigs.getInstance().snowflake = snowflake;
    }

    private static enum SingletonHolder {
        INSTANCE;

        private final ServerConfigs configs = new ServerConfigs();

        public ServerConfigs getConfigs() {
            return this.configs;
        }
    }
}

