/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.lang.NonNull;

public abstract class DateUtils {
    public static Date getDate(Date time) {
        return new Date(time.getYear(), time.getMonth(), time.getDate());
    }

    public static Date getTomorrowDate(Date time) {
        return DateUtils.getDate(new Date(time.getTime() + 86400000L));
    }

    @NonNull
    public static Date parse(String str, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(str);
    }

    @NonNull
    public static Date parseMonth(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy-MM");
    }

    @NonNull
    public static Date parseDate(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy-MM-dd");
    }

    @NonNull
    public static Date parseMinutes(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy-MM-dd HH:mm");
    }

    @NonNull
    public static Date parseSeconds(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy-MM-dd HH:mm:ss");
    }

    @NonNull
    public static Date parseMillisecond(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    @NonNull
    public static Date parseMonth2(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy/MM");
    }

    @NonNull
    public static Date parseDate2(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy/MM/dd");
    }

    public static Date parseMinutes2(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy/MM/dd HH:mm");
    }

    @NonNull
    public static Date parseSeconds2(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy/MM/dd HH:mm:ss");
    }

    @NonNull
    public static Date parseMillisecond2(String str) throws ParseException {
        return DateUtils.parse(str, "yyyy/MM/dd HH:mm:ss.SSS");
    }

    @NonNull
    public static Date parseMonthUnsigned(String str) throws ParseException {
        return DateUtils.parse(str, "yyyyMM");
    }

    @NonNull
    public static Date parseDateUnsigned(String str) throws ParseException {
        return DateUtils.parse(str, "yyyyMMdd");
    }

    @NonNull
    public static Date parseMinutesUnsigned(String str) throws ParseException {
        return DateUtils.parse(str, "yyyyMMddHHmm");
    }

    @NonNull
    public static Date parseSecondsUnsigned(String str) throws ParseException {
        return DateUtils.parse(str, "yyyyMMddHHmmss");
    }

    @NonNull
    public static Date parseMillisecondUnsigned(String str) throws ParseException {
        return DateUtils.parse(str, "yyyyMMddHHmmssSSS");
    }

    @NonNull
    public static Date parseAll(String str) {
        try {
            switch (str.length()) {
                case 7: {
                    if (str.contains("-")) {
                        return DateUtils.parseMonth(str);
                    }
                    return DateUtils.parseMonth2(str);
                }
                case 10: {
                    if (str.contains("-")) {
                        return DateUtils.parseDate(str);
                    }
                    return DateUtils.parseDate2(str);
                }
                case 16: {
                    if (str.contains("-")) {
                        return DateUtils.parseMinutes(str);
                    }
                    return DateUtils.parseSeconds2(str);
                }
                case 19: {
                    if (str.contains("-")) {
                        return DateUtils.parseSeconds(str);
                    }
                    return DateUtils.parseMinutes2(str);
                }
                case 23: {
                    if (str.contains("-")) {
                        return DateUtils.parseMillisecond(str);
                    }
                    return DateUtils.parseMillisecond2(str);
                }
                case 6: {
                    return DateUtils.parseMonthUnsigned(str);
                }
                case 8: {
                    return DateUtils.parseDateUnsigned(str);
                }
                case 12: {
                    return DateUtils.parseMinutesUnsigned(str);
                }
                case 14: {
                    return DateUtils.parseSecondsUnsigned(str);
                }
                case 17: {
                    return DateUtils.parseMillisecondUnsigned(str);
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return new Date(str);
    }

    public static String toString(Date date) {
        if (date == null) {
            return "null";
        }
        long time = date.getTime();
        String dateFormat = date.getHours() == 0 && date.getMinutes() == 0 && date.getSeconds() == 0 && time % 1000L == 0L ? "yyyy-MM-dd" : (time % 60000L == 0L ? "yyyy-MM-dd HH:mm" : (time % 1000L == 0L ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS"));
        return new SimpleDateFormat(dateFormat).format(date);
    }
}

