/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.MapUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.Assert;

public abstract class ReflectionUtils {
    private static final Map<Class<?>, Field[]> CLASS_FIELDS_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Object> SINGLETON_CACHE = new ConcurrentHashMap();

    public static Class<?> getClassByName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    public static Set<Class<?>> getInterfaces(Class<?> clazz) {
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        while (clazz != null) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                interfaces.addAll(ReflectionUtils.getInterfaces(ifc));
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static <T extends AccessibleObject> T setAccessible(T accessible) {
        if (!accessible.isAccessible()) {
            accessible.setAccessible(true);
        }
        return accessible;
    }

    public static Field[] getAllFields(Class<?> targetClazz) {
        if (targetClazz == Object.class || targetClazz.isInterface()) {
            return ArrayUtils.EMPTY_FIELD_ARRAY;
        }
        Field[] fields = CLASS_FIELDS_CACHE.get(targetClazz);
        if (fields != null) {
            return fields;
        }
        fields = targetClazz.getDeclaredFields();
        LinkedList<Field> fieldList = new LinkedList<Field>(Arrays.asList(fields));
        fieldList.removeIf(f -> Modifier.isStatic(f.getModifiers()) || f.isSynthetic());
        Object[] superFields = ReflectionUtils.getAllFields(targetClazz.getSuperclass());
        if (ArrayUtils.isNotEmpty((Object[])superFields)) {
            fieldList.addAll(Arrays.asList(superFields));
        }
        Field[] resultFields = !fieldList.isEmpty() ? fieldList.toArray(new Field[0]) : ArrayUtils.EMPTY_FIELD_ARRAY;
        CLASS_FIELDS_CACHE.put(targetClazz, resultFields);
        return resultFields;
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException, SecurityException {
        Assert.notNull(clazz, (String)"clazz must be not null");
        Assert.notNull((Object)fieldName, (String)"fieldName must be not null");
        for (Class<?> cl = clazz; cl != null && cl != Object.class && !cl.isInterface(); cl = cl.getSuperclass()) {
            try {
                return cl.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("field not found: " + clazz.getName() + ", field: " + fieldName);
    }

    public static <T> T getFieldValue(Object target, Field field) throws IllegalArgumentException, SecurityException {
        Assert.notNull((Object)target, (String)"target must be not null");
        while (true) {
            ReflectionUtils.setAccessible(field);
            try {
                return (T)field.get(target);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            break;
        }
    }

    public static <T> T getFieldValue(Object target, String fieldName) throws IllegalArgumentException, NoSuchFieldException, SecurityException {
        Assert.notNull((Object)target, (String)"target must be not null");
        Field field = ReflectionUtils.getField(target.getClass(), fieldName);
        return ReflectionUtils.getFieldValue(target, field);
    }

    public static void setFieldValue(Object target, Field field, Object fieldValue) throws IllegalArgumentException, SecurityException {
        Assert.notNull((Object)target, (String)"target must be not null");
        while (true) {
            ReflectionUtils.setAccessible(field);
            try {
                field.set(target, fieldValue);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            break;
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object fieldValue) throws IllegalArgumentException, NoSuchFieldException, SecurityException {
        Assert.notNull((Object)target, (String)"target must be not null");
        Field field = ReflectionUtils.getField(target.getClass(), fieldName);
        ReflectionUtils.setFieldValue(target, field, fieldValue);
    }

    public static void setStaticFieldValue(Field staticField, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        Assert.notNull((Object)staticField, (String)"staticField must be not null");
        if (!Modifier.isStatic(staticField.getModifiers())) {
            throw new IllegalArgumentException("the `" + ReflectionUtils.fieldToString(staticField) + "` is not a static field, cannot modify value.");
        }
        if (Modifier.isFinal(staticField.getModifiers())) {
            Field modifiersField = staticField.getClass().getDeclaredField("modifiers");
            ReflectionUtils.setAccessible(modifiersField);
            modifiersField.setInt(staticField, staticField.getModifiers() & 0xFFFFFFEF);
        }
        ReflectionUtils.setAccessible(staticField);
        staticField.set(staticField.getDeclaringClass(), newValue);
    }

    public static void setStaticFieldValue(Class<?> targetClass, String staticFieldName, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        Assert.notNull(targetClass, (String)"targetClass must be not null");
        Field field = targetClass.getDeclaredField(staticFieldName);
        ReflectionUtils.setStaticFieldValue(field, newValue);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Assert.notNull(clazz, (String)"clazz must be not null");
        for (Class<?> cl = clazz; cl != null; cl = cl.getSuperclass()) {
            try {
                return cl.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException("method not found: " + ReflectionUtils.methodToString(clazz, methodName, parameterTypes));
    }

    public static Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException, SecurityException {
        return ReflectionUtils.getMethod(clazz, methodName, ArrayUtils.EMPTY_CLASS_ARRAY);
    }

    public static Object invokeMethod(Object target, Method method, Object ... args) throws InvocationTargetException, IllegalArgumentException, SecurityException {
        while (true) {
            ReflectionUtils.setAccessible(method);
            try {
                return method.invoke(target, args);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            break;
        }
    }

    public static Object invokeMethod(Object target, Method method) throws InvocationTargetException, IllegalArgumentException, SecurityException {
        return ReflectionUtils.invokeMethod(target, method, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Object target, String methodName, Class<?>[] parameterTypes, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, SecurityException {
        Assert.notNull((Object)target, (String)"target must be not null");
        Method method = ReflectionUtils.getMethod(target.getClass(), methodName, parameterTypes);
        return ReflectionUtils.invokeMethod(target, method, args);
    }

    public static Object invokeMethod(Object target, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, SecurityException {
        return ReflectionUtils.invokeMethod(target, methodName, ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeStaticMethod(Method staticMethod, Object ... args) throws IllegalArgumentException, InvocationTargetException, SecurityException {
        Assert.notNull((Object)staticMethod, (String)"staticMethod must be not null");
        if (!Modifier.isStatic(staticMethod.getModifiers())) {
            throw new IllegalArgumentException("`" + ReflectionUtils.methodToString(staticMethod) + "` is not a static method");
        }
        return ReflectionUtils.invokeMethod(null, staticMethod, args);
    }

    public static Object invokeStaticMethod(Method staticMethod) throws InvocationTargetException, IllegalArgumentException, SecurityException {
        return ReflectionUtils.invokeStaticMethod(staticMethod, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeStaticMethod(Class<?> targetClass, String staticMethodName, Class<?>[] parameterTypes, Object ... args) throws IllegalArgumentException, NoSuchMethodException, InvocationTargetException, SecurityException {
        Assert.notNull(targetClass, (String)"targetClass must be not null");
        Method staticMethod = ReflectionUtils.getMethod(targetClass, staticMethodName, parameterTypes);
        if (!Modifier.isStatic(staticMethod.getModifiers())) {
            throw new NoSuchMethodException("static method not found: " + ReflectionUtils.methodToString(targetClass, staticMethodName, parameterTypes));
        }
        return ReflectionUtils.invokeStaticMethod(staticMethod, args);
    }

    public static Object invokeStaticMethod(Class<?> targetClass, String staticMethodName) throws IllegalArgumentException, NoSuchMethodException, SecurityException, InvocationTargetException {
        return ReflectionUtils.invokeStaticMethod(targetClass, staticMethodName, ArrayUtils.EMPTY_CLASS_ARRAY, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static boolean equalsMethod(Method m1, Method m2) {
        if (m1 == null) {
            return m2 == null;
        }
        if (m2 == null) {
            return false;
        }
        if (m1.equals(m2)) {
            return true;
        }
        if (!m1.getName().equals(m2.getName()) || m1.getParameterCount() != m2.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < m1.getParameterCount(); ++i) {
            if (m1.getParameterTypes()[i].equals(m2.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsMethod(Collection<Method> methods, Method method) {
        if (methods.contains(method)) {
            return true;
        }
        for (Method m : methods) {
            if (!ReflectionUtils.equalsMethod(m, method)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMethod(Map<Method, ?> methodMap, Method method) {
        if (methodMap.isEmpty()) {
            return false;
        }
        return ReflectionUtils.containsMethod(methodMap.keySet(), method);
    }

    public static boolean hasMethod(Class<?> clazz, Method method) {
        if (method.getDeclaringClass() == clazz) {
            return true;
        }
        try {
            clazz.getMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation == null) {
            for (Class<?> superClass = method.getDeclaringClass().getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                try {
                    Method m = superClass.getMethod(method.getName(), method.getParameterTypes());
                    annotation = m.getAnnotation(annotationClass);
                    if (annotation != null) {
                        return annotation;
                    }
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return annotation;
    }

    public static Map<String, Object> getAnnotationValues(Annotation annotation) throws NoSuchFieldException {
        InvocationHandler h = Proxy.getInvocationHandler(annotation);
        return (Map)ReflectionUtils.getFieldValue((Object)h, "memberValues");
    }

    public static <T> T getSingleton(Class<T> clazz) {
        Assert.notNull(clazz, (String)"clazz must be not null");
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("clazz must be not an interface: " + clazz);
        }
        return (T)MapUtils.computeIfAbsent(SINGLETON_CACHE, clazz, key -> {
            try {
                return clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("new instance failed, class: " + clazz, e);
            }
        });
    }

    public static String classToString(Class<?> clazz) {
        return "Class<" + clazz.getSimpleName() + ">";
    }

    public static String fieldToString(Class<?> clazz, String fieldName, Class<?> fieldType) {
        return "Field<" + clazz.getSimpleName() + ".(" + fieldType.getSimpleName() + ")" + fieldName + ">";
    }

    public static String fieldToString(Field field) {
        return ReflectionUtils.fieldToString(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public static String methodToString(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return "Method<" + clazz.getSimpleName() + "." + methodName + ReflectionUtils.parameterTypesToString(parameterTypes) + ">";
    }

    public static String methodToString(Method method) {
        String methodStr = method.getDeclaringClass().getSimpleName() + "." + method.getName() + ReflectionUtils.parameterTypesToString(method.getParameterTypes());
        if (Modifier.isStatic(method.getModifiers())) {
            methodStr = "static " + methodStr;
        }
        return "Method<" + methodStr + ">";
    }

    public static String annotationToString(Annotation annotation) {
        if (annotation == null) {
            return "null";
        }
        String annoStr = annotation.toString();
        String annoValueStr = annoStr.substring(annoStr.indexOf(40));
        return "@" + annotation.annotationType().getSimpleName() + annoValueStr;
    }

    public static String parameterTypesToString(Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (parameterTypes != null) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((c = parameterTypes[i]) == null ? "null" : c.getSimpleName());
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

