/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.CycleDependencyHandler;
import icu.easyj.core.util.DateUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.springframework.lang.NonNull;

public abstract class StringUtils {
    public static int getStrLength(String str) {
        if (str == null || str.isEmpty()) {
            return 0;
        }
        int valueLength = str.length();
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < str.length(); ++i) {
            String temp = str.substring(i, i + 1);
            if (!temp.matches(chinese)) continue;
            ++valueLength;
        }
        return valueLength;
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence || obj instanceof Number || obj instanceof Boolean || obj instanceof Character) {
            return obj.toString();
        }
        if (obj instanceof Date) {
            return DateUtils.toString((Date)obj);
        }
        if (obj instanceof Enum) {
            return obj.getClass().getSimpleName() + "." + ((Enum)obj).name();
        }
        if (obj instanceof Class) {
            return ReflectionUtils.classToString((Class)obj);
        }
        if (obj instanceof Field) {
            return ReflectionUtils.fieldToString((Field)obj);
        }
        if (obj instanceof Method) {
            return ReflectionUtils.methodToString((Method)obj);
        }
        if (obj instanceof Annotation) {
            return ReflectionUtils.annotationToString((Annotation)obj);
        }
        if (obj instanceof Collection) {
            return CollectionUtils.toString((Collection)obj);
        }
        if (obj instanceof Map) {
            return MapUtils.toString((Map)obj);
        }
        if (obj.getClass().isArray()) {
            return ArrayUtils.toString((Object[])obj);
        }
        return StringUtils.unknownTypeObjectToString(obj);
    }

    private static String unknownTypeObjectToString(@NonNull Object obj) {
        return CycleDependencyHandler.wrap(obj, o -> {
            Field[] fields;
            StringBuilder sb = new StringBuilder(32);
            sb.append(obj.getClass().getSimpleName()).append("(");
            int initialLength = sb.length();
            for (Field field : fields = ReflectionUtils.getAllFields(obj.getClass())) {
                Object fieldValue;
                if (sb.length() > initialLength) {
                    sb.append(", ");
                }
                sb.append(field.getName());
                sb.append("=");
                try {
                    fieldValue = ReflectionUtils.getFieldValue(obj, field);
                }
                catch (Exception ignore) {
                    continue;
                }
                if (fieldValue == obj) {
                    sb.append("(this ").append(fieldValue.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(StringUtils.toString(fieldValue));
            }
            sb.append(")");
            return sb.toString();
        });
    }
}

