/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.clock;

import icu.easyj.core.util.clock.ITickClock;

public class TickClock
implements ITickClock {
    private final long baseEpochMillis;
    private final long baseEpochMicros;
    private final long baseEpochNanos;
    private final long baseTickNanos;

    public TickClock(long baseEpochMicros, long baseTickNanos) {
        this.baseEpochMillis = baseEpochMicros / 1000L;
        this.baseEpochMicros = baseEpochMicros;
        this.baseEpochNanos = baseEpochMicros * 1000L;
        this.baseTickNanos = baseTickNanos;
    }

    public TickClock(long baseEpochMicros) {
        this(baseEpochMicros, System.nanoTime());
    }

    @Override
    public long currentTimeMillis() {
        return this.getPassedNanos() / 1000000L + this.baseEpochMillis;
    }

    @Override
    public long currentTimeMicros() {
        return this.getPassedNanos() / 1000L + this.baseEpochMicros;
    }

    @Override
    public long currentTimeNanos() {
        return this.getPassedNanos() + this.baseEpochNanos;
    }

    @Override
    public long getBaseEpochMicros() {
        return this.baseEpochMicros;
    }

    @Override
    public long getBaseTickNanos() {
        return this.baseTickNanos;
    }
}

