/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import java.util.regex.Pattern;

public abstract class Base64Utils {
    public static final String REGEX_CRLF = "[\\r\\n]";
    public static final Pattern P_CRLF = Pattern.compile("[\\r\\n]+");

    public static String normalize(String base64Str) {
        if (base64Str.contains(" ")) {
            base64Str = base64Str.replace(" ", "+");
        }
        if (base64Str.contains("%")) {
            if (base64Str.contains("%25")) {
                base64Str = base64Str.replaceAll("%25", "%");
            }
            if (base64Str.contains("%2B")) {
                base64Str = base64Str.replace("%2B", "+");
            }
            if (base64Str.contains("%2F")) {
                base64Str = base64Str.replace("%2F", "/");
            }
            if (base64Str.endsWith("%3D")) {
                base64Str = base64Str.replace("%3D", "=");
            }
        }
        if (base64Str.contains("\n") || base64Str.contains("\r")) {
            base64Str = P_CRLF.matcher(base64Str).replaceAll("");
        }
        return base64Str;
    }
}

