/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;

public abstract class NetUtils {
    public static final String PORT_RANGE = "1024,65535";

    public static List<String> getIpList() {
        Object ip;
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (((InetAddress)ip).isLoopbackAddress() || ((InetAddress)ip).getHostAddress().indexOf(58) != -1 || "127.0.0.1".equals(((InetAddress)ip).getHostAddress())) continue;
                    result.add(((InetAddress)ip).getHostAddress());
                }
            }
        }
        catch (Exception ip2) {
            // empty catch block
        }
        if (result.isEmpty()) {
            ip = NetUtils.getIp();
            result.add((String)ip);
        }
        return result;
    }

    public static String getIp() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("getLocalHost\u5931\u8d25", e);
        }
        return addr.getHostAddress();
    }

    public static int randomPort(int startPort, int endPort) {
        if (endPort > 65535 || endPort < 1024) {
            endPort = 65535;
        }
        if (startPort < 1024) {
            startPort = 1024;
        }
        return RandomUtils.nextInt((int)startPort, (int)endPort);
    }

    public static int randomPort(int startPort) {
        return NetUtils.randomPort(startPort, 65535);
    }

    public static int randomPort() {
        return NetUtils.randomPort(1024, 65535);
    }
}

