/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.clock;

import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.clock.IClock;
import icu.easyj.core.util.clock.IRemotingClockHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class AbstractRemotingClockHolder<T>
implements IRemotingClockHolder<T> {
    private final Map<T, IClock> remotingClockMap;

    protected AbstractRemotingClockHolder() {
        this.remotingClockMap = new ConcurrentHashMap<T, IClock>(2);
    }

    protected AbstractRemotingClockHolder(Map<T, IClock> remotingClockMap) {
        this.remotingClockMap = remotingClockMap;
    }

    @Override
    @NonNull
    public IClock getClock(T remotingKey) {
        Assert.notNull(remotingKey, (String)"remotingKey must be not null");
        return MapUtils.computeIfAbsent(this.remotingClockMap, remotingKey, ds -> this.createClock(remotingKey));
    }

    @Override
    @NonNull
    public IClock refreshClock(T remotingKey) {
        Assert.notNull(remotingKey, (String)"remotingKey must be not null");
        IClock newClock = this.createClock(remotingKey);
        this.remotingClockMap.put(remotingKey, newClock);
        return newClock;
    }
}

