/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import java.nio.charset.StandardCharsets;

public abstract class Base64Utils {
    public static final byte[] BASE64_CHAR_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 43, -1, -1, -1, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -1, -1, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    public static final char PADDING_CHAR = '=';

    public static String normalize(String base64Str) throws IllegalArgumentException {
        boolean needToChange = false;
        int base64Length = base64Str.length();
        StringBuilder sb = new StringBuilder(base64Length > 500 ? base64Length / 2 : base64Length);
        int i = 0;
        byte[] bytes = null;
        block7: while (i < base64Length) {
            char c = base64Str.charAt(i);
            switch (c) {
                case ' ': {
                    sb.append('+');
                    ++i;
                    needToChange = true;
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    ++i;
                    needToChange = true;
                    continue block7;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(base64Length - i) / 3];
                        }
                        int pos = 0;
                        while (c == '%' && i + 2 < base64Length) {
                            String hex = base64Str.substring(i + 1, i + 3);
                            int v = Integer.parseInt(hex, 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("\u8f6c\u4e49\uff08%\uff09\u6a21\u5f0f\u65f6\u5b58\u5728\u975e\u6cd5\u5341\u516d\u8fdb\u5236\u5b57\u7b26-\u8d1f\u503c: %" + hex + " -> " + v);
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= base64Length) continue;
                            c = base64Str.charAt(i);
                        }
                        if (c == '%' && i < base64Length) {
                            throw new IllegalArgumentException("\u4e0d\u5b8c\u6574\u7684\u8f6c\u4e49\uff08%\uff09\u6a21\u5f0f");
                        }
                        sb.append(new String(bytes, 0, pos, StandardCharsets.UTF_8));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("\u8f6c\u4e49\uff08%\uff09\u6a21\u5f0f\u4e2d\u7684\u975e\u6cd5\u5341\u516d\u8fdb\u5236\u5b57\u7b26 - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block7;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : base64Str;
    }

    public static boolean isBase64Char(char c) {
        return c < BASE64_CHAR_TABLE.length && BASE64_CHAR_TABLE[c] != -1;
    }

    public static boolean isBase64(CharSequence str) {
        int length;
        if (str == null || str.length() < 2) {
            return false;
        }
        char[] charArr = str.toString().toCharArray();
        if (charArr[(length = charArr.length) - 1] == '=') {
            if (str.length() % 4 != 0) {
                return false;
            }
            if (charArr[--length - 1] == '=') {
                --length;
            }
        }
        for (int i = 0; i < length; ++i) {
            char c = charArr[i];
            if (Base64Utils.isBase64Char(c)) continue;
            return false;
        }
        return true;
    }
}

