/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class ThrowableUtils {
    @Nullable
    public static <T extends Throwable> T findCause(@NonNull Throwable t, @NonNull Class<T> causeClass) {
        Assert.notNull((Object)t, (String)"'t' must be not null");
        Assert.notNull(causeClass, (String)"'causeClass' must be not null");
        while (t != null) {
            if (causeClass.isAssignableFrom(t.getClass())) {
                return (T)t;
            }
            t = t.getCause();
        }
        return null;
    }

    public static boolean containsCause(@NonNull Throwable t, @NonNull Class<? extends Throwable> causeClass) {
        return ThrowableUtils.findCause(t, causeClass) != null;
    }
}

