/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.convert;

import cn.hutool.core.lang.Assert;
import icu.easyj.core.convert.converter.CharSequenceToDateConverter;
import icu.easyj.core.convert.converter.DateToStringConverter;
import icu.easyj.core.enums.DataType;
import icu.easyj.core.exception.ConvertException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class ConvertUtils {
    private static final DefaultConversionService CONVERSION_SERVICE;

    public static DefaultConversionService getConversionService() {
        return CONVERSION_SERVICE;
    }

    public static void addConvert(@NonNull Converter<?, ?> converter) {
        Assert.notNull(converter, (String)"'converter' must not be null", (Object[])new Object[0]);
        CONVERSION_SERVICE.addConverter(converter);
    }

    public static boolean canConvert(@Nullable Class<?> sourceType, Class<?> targetType) {
        return ConvertUtils.getConversionService().canConvert(sourceType, targetType);
    }

    public static boolean canConvert(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        return ConvertUtils.getConversionService().canConvert(sourceType, targetType);
    }

    public static boolean canConvert(@Nullable DataType sourceType, DataType targetType) {
        if (sourceType == null) {
            return true;
        }
        Assert.notNull((Object)((Object)targetType), (String)"'targetType' must not be null", (Object[])new Object[0]);
        return ConvertUtils.canConvert(sourceType.getTypeDesc(), targetType.getTypeDesc());
    }

    public static <T> T convert(@Nullable Object source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        try {
            return (T)ConvertUtils.getConversionService().convert(source, targetClass);
        }
        catch (IllegalArgumentException | ConversionException e) {
            throw new ConvertException("\u6570\u636e\u8f6c\u6362\u5931\u8d25", e);
        }
    }

    public static <T> T convert(@Nullable Object source, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        try {
            return (T)ConvertUtils.getConversionService().convert(source, targetType);
        }
        catch (IllegalArgumentException | ConversionException e) {
            throw new ConvertException("\u6570\u636e\u8f6c\u6362\u5931\u8d25", e);
        }
    }

    public static <T> T convert(@Nullable Object source, DataType targetType) {
        if (source == null) {
            return null;
        }
        Assert.notNull((Object)((Object)targetType), (String)"'targetType' must not be null", (Object[])new Object[0]);
        return ConvertUtils.convert(source, targetType.getTypeDesc());
    }

    public static <T> T convert(@Nullable Object source, Class<T> targetClass, @Nullable T defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        try {
            return ConvertUtils.convert(source, targetClass);
        }
        catch (ConvertException e) {
            return defaultValue;
        }
    }

    public static <T> T convert(@Nullable Object source, TypeDescriptor targetType, @Nullable T defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        try {
            return ConvertUtils.convert(source, targetType);
        }
        catch (ConvertException e) {
            return defaultValue;
        }
    }

    public static <T> T convert(@Nullable Object source, DataType targetType, @Nullable T defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        Assert.notNull((Object)((Object)targetType), (String)"'targetType' must not be null", (Object[])new Object[0]);
        return ConvertUtils.convert(source, targetType.getTypeDesc(), defaultValue);
    }

    @NonNull
    public static <T> List<T> convertList(@Nullable Collection<?> sourceList, Class<T> targetClass) {
        ArrayList<T> list = new ArrayList<T>();
        if (sourceList != null) {
            for (Object source : sourceList) {
                list.add(ConvertUtils.convert(source, targetClass));
            }
        }
        return list;
    }

    @NonNull
    public static <T> List<T> convertList(@Nullable Collection<?> sourceList, TypeDescriptor targetType) {
        ArrayList<T> list = new ArrayList<T>();
        if (sourceList != null) {
            for (Object source : sourceList) {
                list.add(ConvertUtils.convert(source, targetType));
            }
        }
        return list;
    }

    @NonNull
    public static <T> List<T> convertList(@Nullable Collection<?> sourceList, DataType targetType) {
        if (sourceList == null) {
            return new ArrayList();
        }
        Assert.notNull((Object)((Object)targetType), (String)"'targetType' must not be null", (Object[])new Object[0]);
        return ConvertUtils.convertList(sourceList, targetType.getTypeDesc());
    }

    static {
        DefaultConversionService cs = (DefaultConversionService)DefaultConversionService.getSharedInstance();
        cs.addConverter((Converter)new DateToStringConverter());
        cs.addConverter((Converter)new CharSequenceToDateConverter());
        CONVERSION_SERVICE = cs;
    }
}

